/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone;

import de.sarocesch.minewacheroleplaymod.gui.builder.texture.TextureCache;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.util.PhoneDebug;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class PhoneBackgrounds {
    private static final String CONFIG_REL = "config/mw_phone/backgrounds";
    private static final Map<String, CacheEntry> CACHE = new HashMap<String, CacheEntry>();

    public static File getDir() {
        File base = Minecraft.func_71410_x().field_71412_D;
        File dir = new File(base, CONFIG_REL);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void ensureDefaults() {
        File dir = PhoneBackgrounds.getDir();
        PhoneBackgrounds.copyBundledIfMissing(new File(dir, "default_dark.png"), "saros_new_blocks_mod:textures/phone/backgrounds/default_dark.png", PhoneBackgrounds::imgDefaultDark);
        PhoneBackgrounds.copyBundledIfMissing(new File(dir, "default_light.png"), "saros_new_blocks_mod:textures/phone/backgrounds/default_light.png", PhoneBackgrounds::imgDefaultLight);
        PhoneBackgrounds.copyBundledIfMissing(new File(dir, "default_gradient.png"), "saros_new_blocks_mod:textures/phone/backgrounds/default_gradient.png", PhoneBackgrounds::imgDefaultGradient);
    }

    private static void copyBundledIfMissing(File file, String resourceLoc, ImgSupplier fallback) {
        if (file.exists()) {
            return;
        }
        try {
            ResourceLocation rl = new ResourceLocation(resourceLoc);
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(rl).func_110527_b();
            Files.copy(in, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            in.close();
            try {
                PhoneDebug.log("[PHONE] Copied bundled background to " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {}
        }
        catch (Exception e) {
            try {
                PhoneDebug.log("[PHONE] Bundled background not found (" + resourceLoc + "), generating fallback: " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            PhoneBackgrounds.createGenerated(file, fallback);
        }
    }

    private static void createGenerated(File file, ImgSupplier sup) {
        try {
            BufferedImage img = sup.get();
            ImageIO.write((RenderedImage)img, "PNG", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BufferedImage imgDefaultDark() {
        BufferedImage img = new BufferedImage(170, 300, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(new Color(18, 19, 21));
        g.fillRect(0, 0, 170, 300);
        g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(34, 36, 40), 0.0f, 300.0f, new Color(23, 25, 28)));
        g.fillRect(0, 0, 170, 300);
        g.dispose();
        return img;
    }

    private static BufferedImage imgDefaultLight() {
        BufferedImage img = new BufferedImage(170, 300, 2);
        Graphics2D g = img.createGraphics();
        g.setColor(new Color(243, 244, 246));
        g.fillRect(0, 0, 170, 300);
        g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 0.0f, 300.0f, new Color(236, 239, 243)));
        g.fillRect(0, 0, 170, 300);
        g.dispose();
        return img;
    }

    private static BufferedImage imgDefaultGradient() {
        BufferedImage img = new BufferedImage(170, 300, 2);
        Graphics2D g = img.createGraphics();
        g.setPaint(new GradientPaint(0.0f, 0.0f, new Color(91, 134, 229), 170.0f, 300.0f, new Color(54, 209, 220)));
        g.fillRect(0, 0, 170, 300);
        g.dispose();
        return img;
    }

    public static List<String> listBackgrounds() {
        PhoneBackgrounds.ensureDefaults();
        File[] files = PhoneBackgrounds.getDir().listFiles((d, n) -> n.toLowerCase(Locale.ROOT).endsWith(".png"));
        ArrayList<String> out = new ArrayList<String>();
        if (files != null) {
            for (File f : files) {
                out.add(f.getName());
            }
        }
        Collections.sort(out);
        return out;
    }

    private static CacheEntry ensureTexture(String name) {
        PhoneBackgrounds.ensureDefaults();
        File file = new File(PhoneBackgrounds.getDir(), name);
        if (!file.exists()) {
            return null;
        }
        long lm = file.lastModified();
        CacheEntry ce = CACHE.get(name);
        if (ce == null || ce.lastModified != lm) {
            try {
                BufferedImage img = ImageIO.read(file);
                if (img == null) {
                    return null;
                }
                DynamicTexture dyn = new DynamicTexture(img);
                ResourceLocation rl = Minecraft.func_71410_x().func_110434_K().func_110578_a("mw_phone/bg/" + name, dyn);
                ce = new CacheEntry();
                ce.rl = rl;
                ce.lastModified = lm;
                ce.w = img.getWidth();
                ce.h = img.getHeight();
                CACHE.put(name, ce);
            }
            catch (IOException e) {
                return null;
            }
        }
        return ce;
    }

    public static void drawSelected(Minecraft mc, int x, int y, int w, int h) {
        String name = PhoneClientState.settings.background != null ? PhoneClientState.settings.background : "default_dark.png";
        PhoneBackgrounds.draw(mc, name, x, y, w, h);
    }

    public static void draw(Minecraft mc, String name, int x, int y, int w, int h) {
        try {
            ResourceLocation fromCache = TextureCache.get("phone/backgrounds/" + name);
            if (fromCache != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                mc.func_110434_K().func_110577_a(fromCache);
                Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)w, (float)h);
                return;
            }
        }
        catch (Exception fromCache) {
            // empty catch block
        }
        CacheEntry ce = PhoneBackgrounds.ensureTexture(name);
        if (ce == null) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(ce.rl);
        Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)ce.w, (float)ce.h);
    }

    public static interface ImgSupplier {
        public BufferedImage get();
    }

    private static class CacheEntry {
        ResourceLocation rl;
        long lastModified;
        int w;
        int h;

        private CacheEntry() {
        }
    }
}

