/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone.apps;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneScreen;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneUpdateNicknames;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ContactsApp
implements PhoneApp {
    private PhoneScreen host;
    private GuiTextField nicknameField;
    private String selected = null;
    private int nickX;
    private int nickY;
    private int nickW;
    private int nickH;
    private int scroll = 0;

    @Override
    public String getTitle() {
        return "Contacts";
    }

    @Override
    public String getIconLabel() {
        return "CONT";
    }

    @Override
    public void setHost(PhoneScreen host) {
        this.host = host;
    }

    @Override
    public void onOpen() {
        this.nicknameField = null;
        this.selected = null;
    }

    @Override
    public void draw(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY, float pt) {
        ArrayList<String> players = new ArrayList<String>(PhoneClientState.online.keySet());
        players.sort(String::compareToIgnoreCase);
        int rowH = 20;
        int yPos = y - this.scroll;
        int maxScroll = Math.max(0, players.size() * rowH - h);
        if (this.scroll > maxScroll) {
            this.scroll = maxScroll;
        }
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        for (String p : players) {
            if (yPos + rowH >= y && yPos <= y + h) {
                boolean on = PhoneClientState.online.getOrDefault(p, false);
                Gui.func_73734_a((int)x, (int)yPos, (int)(x + w), (int)(yPos + rowH - 1), (int)858467891);
                String name = PhoneClientState.nicknames.getOrDefault(p, p);
                mc.field_71466_p.func_78276_b(name, x + 6, yPos + 6, 0xFFFFFF);
                String status = on ? "Online" : "Offline";
                int color = on ? 8190976 : 14689316;
                mc.field_71466_p.func_78276_b(status, x + w - 6 - mc.field_71466_p.func_78256_a(status), yPos + 6, color);
            }
            yPos += rowH;
        }
        if (this.selected != null) {
            if (this.nicknameField == null) {
                this.nicknameField = new GuiTextField(3101, mc.field_71466_p, x + 6, y + h - 18, w - 80, 16);
                String existing = PhoneClientState.nicknames.getOrDefault(this.selected, "");
                this.nicknameField.func_146180_a(existing);
                this.nicknameField.func_146195_b(true);
            }
            this.nickX = 6;
            this.nickY = h - 18;
            this.nickW = w - 80;
            this.nickH = 16;
            this.nicknameField.field_146209_f = x + this.nickX;
            this.nicknameField.field_146210_g = y + this.nickY;
            this.nicknameField.field_146218_h = this.nickW;
            this.nicknameField.field_146219_i = this.nickH;
            this.nicknameField.func_146194_f();
            Gui.func_73734_a((int)(x + w - 70), (int)(y + h - 18), (int)(x + w - 6), (int)(y + h - 2), (int)-12944642);
            mc.field_71466_p.func_78276_b("Save", x + w - 52, y + h - 15, 0xFFFFFF);
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        int rowH = 20;
        ArrayList<String> players = new ArrayList<String>(PhoneClientState.online.keySet());
        players.sort(String::compareToIgnoreCase);
        int idx = (mouseY + this.scroll) / rowH;
        if (idx >= 0 && idx < players.size()) {
            this.selected = (String)players.get(idx);
            if (!this.selected.equals(PhoneClientState.self())) {
                PhoneClientState.conversations.computeIfAbsent(this.selected, id -> {
                    PhoneClientState.Conversation c = new PhoneClientState.Conversation();
                    c.id = id;
                    c.group = false;
                    c.title = id;
                    return c;
                });
            }
        }
        if (this.selected != null && this.nicknameField != null) {
            int bx = this.nickX + this.nickW + 4;
            int by = this.nickY;
            int bw = 64;
            int bh = this.nickH;
            if (mouseX >= bx && mouseX <= bx + bw && mouseY >= by && mouseY <= by + bh) {
                String nick = this.nicknameField.func_146179_b().trim();
                int handIndex = this.host != null ? this.host.getHandIndex() : 0;
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneUpdateNicknames(handIndex, this.selected, nick));
                PhoneClientState.nicknames.put(this.selected, nick);
                return;
            }
            if (mouseX >= this.nickX && mouseX <= this.nickX + this.nickW && mouseY >= this.nickY && mouseY <= this.nickY + this.nickH) {
                this.nicknameField.func_146195_b(true);
            }
        }
    }

    @Override
    public void mouseScrolled(int delta) {
        int step = 10 * Integer.signum(-delta);
        this.scroll += step;
        if (this.scroll < 0) {
            this.scroll = 0;
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.nicknameField != null) {
            this.nicknameField.func_146201_a(typedChar, keyCode);
        }
    }

    private static String formatLast(long ts) {
        if (ts <= 0L) {
            return "a while ago";
        }
        long diff = System.currentTimeMillis() - ts;
        if (diff < 60000L) {
            return "just now";
        }
        if (diff < 3600000L) {
            return diff / 60000L + " min ago";
        }
        SimpleDateFormat df = new SimpleDateFormat("MMM d HH:mm");
        return df.format(new Date(ts));
    }

    @Override
    public boolean blocksPlayerMovement() {
        return this.nicknameField != null && this.nicknameField.func_146206_l();
    }
}

