/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class UndoRedoHandler {
    public static Stack<List<BlockStatePos>> undoStack = new Stack();
    public static Stack<List<BlockStatePos>> redoStack = new Stack();

    public static void pushToUndo(List<BlockStatePos> states) {
        undoStack.push(states);
        redoStack.clear();
    }

    public static List<BlockStatePos> popFromUndo() {
        if (!undoStack.isEmpty()) {
            return undoStack.pop();
        }
        return new ArrayList<BlockStatePos>();
    }

    public static void pushToRedo(List<BlockStatePos> states) {
        redoStack.push(states);
    }

    public static List<BlockStatePos> popFromRedo() {
        if (!redoStack.isEmpty()) {
            return redoStack.pop();
        }
        return new ArrayList<BlockStatePos>();
    }

    public static boolean canUndo() {
        return !undoStack.isEmpty();
    }

    public static boolean canRedo() {
        return !redoStack.isEmpty();
    }

    public static class BlockStatePos {
        private final BlockPos pos;
        private final IBlockState state;
        private final NBTTagCompound nbt;

        public BlockStatePos(BlockPos pos, IBlockState state, NBTTagCompound nbt) {
            this.pos = pos;
            this.state = state;
            this.nbt = nbt;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public IBlockState getState() {
            return this.state;
        }

        public NBTTagCompound getNbt() {
            return this.nbt;
        }
    }
}

