/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.item;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.creativetab.TabSarosNewBlocksMod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsMinewacheRolePlayMod.ModElement.Tag
@Mod.EventBusSubscriber
public class ItemRoadUpdater
extends ElementsMinewacheRolePlayMod.ModElement {
    @GameRegistry.ObjectHolder(value="saros_new_blocks_mod:road_updater")
    public static final Item block = null;
    private static final String MODE_KEY = "Mode";
    private static final String HISTORY_KEY = "History";
    private static final String RADIUS_KEY = "Radius";
    private static final int MAX_MODES = 4;
    private static final int MAX_HISTORY = 5;
    private static final String[][] MODES = new String[][]{{"furenikusroads:road_block_standard", "furenikusroads:road_block_fine"}, {"furenikusroads:road_block_standard", "furenikusroads:road_block_dark"}, {"furenikusroads:road_block_dark", "furenikusroads:road_block_standard"}, {"furenikusroads:road_block_fine", "furenikusroads:road_block_dark"}};

    public ItemRoadUpdater(ElementsMinewacheRolePlayMod instance) {
        super(instance, 374);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player;
        ItemStack heldItem;
        if (Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151470_d()) {
            EntityPlayerSP player2 = Minecraft.func_71410_x().field_71439_g;
            ItemStack heldItem2 = player2.func_184614_ca();
            if (heldItem2 != null && heldItem2.func_77973_b() == block && event.getDwheel() != 0) {
                ItemRoadUpdater.changeMode(heldItem2, event.getDwheel() > 0, (EntityPlayer)player2);
                event.setCanceled(true);
            }
        } else if (Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151470_d() && (heldItem = (player = Minecraft.func_71410_x().field_71439_g).func_184614_ca()) != null && heldItem.func_77973_b() == block && event.getDwheel() != 0) {
            ItemRoadUpdater.changeRadius(heldItem, event.getDwheel() > 0, (EntityPlayer)player);
            event.setCanceled(true);
        }
    }

    private static void changeMode(ItemStack stack, boolean forward, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int mode = nbt.func_74762_e(MODE_KEY);
        mode = (mode + (forward ? 1 : -1) + 4) % 4;
        nbt.func_74768_a(MODE_KEY, mode);
        stack.func_77982_d(nbt);
        player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Modus: " + mode), true);
        player.field_71071_by.func_70296_d();
    }

    private static void changeRadius(ItemStack stack, boolean increase, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int radius = nbt.func_74762_e(RADIUS_KEY);
        radius = Math.max(1, radius + (increase ? 1 : -1));
        nbt.func_74768_a(RADIUS_KEY, radius);
        stack.func_77982_d(nbt);
        player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Radius: " + radius), true);
        System.out.println("Neuer Radius: " + radius);
        player.field_71071_by.func_70296_d();
    }

    private static void updateBlocks(World world, BlockPos pos, Block fromBlock, Block toBlock, int fromMeta, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        ArrayList<String> stepHistory = new ArrayList<String>();
        int radius = stack.func_77978_p().func_74762_e(RADIUS_KEY);
        System.out.println("Aktualisierungsradius: " + radius);
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                BlockPos newPos = pos.func_177982_a(x, 0, z);
                IBlockState state = world.func_180495_p(newPos);
                if (state.func_177230_c() != fromBlock || fromBlock.func_176201_c(state) != fromMeta) continue;
                stepHistory.add(newPos.func_177958_n() + "," + newPos.func_177956_o() + "," + newPos.func_177952_p() + "," + Block.field_149771_c.func_177774_c((Object)state.func_177230_c()) + "," + state.func_177230_c().func_176201_c(state));
                world.func_175656_a(newPos, toBlock.func_176203_a(fromMeta));
            }
        }
        if (!stepHistory.isEmpty()) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound nbt = stack.func_77978_p();
            List<String> history = ItemRoadUpdater.getHistory(nbt);
            history.add(0, String.join((CharSequence)";", stepHistory));
            if (history.size() > 5) {
                history = history.subList(0, 5);
            }
            nbt.func_74778_a(HISTORY_KEY, String.join((CharSequence)"|", history));
            stack.func_77982_d(nbt);
        }
    }

    private static List<String> getHistory(NBTTagCompound nbt) {
        ArrayList<String> history = new ArrayList<String>();
        if (nbt.func_74764_b(HISTORY_KEY)) {
            String[] historyEntries = nbt.func_74779_i(HISTORY_KEY).split("\\|");
            Collections.addAll(history, historyEntries);
        }
        return history;
    }

    private static void undoUpdate(World world, ItemStack stack) {
        NBTTagCompound nbt;
        List<String> history;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(HISTORY_KEY) && !(history = ItemRoadUpdater.getHistory(nbt = stack.func_77978_p())).isEmpty()) {
            String[] stepEntries;
            for (String entry : stepEntries = history.remove(0).split(";")) {
                String[] parts = entry.split(",");
                BlockPos pos = new BlockPos(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
                Block block = Block.func_149684_b((String)parts[3]);
                int meta = Integer.parseInt(parts[4]);
                if (block == null) continue;
                world.func_175656_a(pos, block.func_176203_a(meta));
            }
            if (history.isEmpty()) {
                nbt.func_82580_o(HISTORY_KEY);
            } else {
                nbt.func_74778_a(HISTORY_KEY, String.join((CharSequence)"|", history));
            }
            stack.func_77982_d(nbt);
        }
    }

    @Override
    public void initElements() {
        this.elements.items.add(() -> new ItemCustom());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        ModelLoader.setCustomModelResourceLocation((Item)block, (int)0, (ModelResourceLocation)new ModelResourceLocation("saros_new_blocks_mod:road_updater", "inventory"));
    }

    public static class ItemCustom
    extends Item {
        public ItemCustom() {
            this.func_77656_e(0);
            this.field_77777_bU = 1;
            this.func_77655_b("road_updater");
            this.setRegistryName("road_updater");
            this.func_77637_a(TabSarosNewBlocksMod.tab);
        }

        public int func_77619_b() {
            return 0;
        }

        public int func_77626_a(ItemStack itemstack) {
            return 0;
        }

        public float func_150893_a(ItemStack par1ItemStack, IBlockState par2Block) {
            return 1.0f;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_77636_d(ItemStack itemstack) {
            return true;
        }

        @SideOnly(value=Side.CLIENT)
        public void func_77624_a(ItemStack itemstack, World world, List<String> list, ITooltipFlag flag) {
            super.func_77624_a(itemstack, world, list, flag);
            list.add(Dateiverwaltung.standard + "Shift-Scrollen zum Modus wechseln");
            list.add(Dateiverwaltung.standard + "Strg-Scrollen zum Radius \ufffdndern");
            list.add(Dateiverwaltung.standard + "Shift-Rechtsklick zum R\ufffdckg\ufffdngigmachen der letzten \ufffdnderung");
            list.add(Dateiverwaltung.standard + "Bis zu 5 Schritte k\ufffdnnen r\ufffdckg\ufffdngig gemacht werden.");
            if (itemstack.func_77942_o()) {
                int mode = itemstack.func_77978_p().func_74762_e(ItemRoadUpdater.MODE_KEY);
                int radius = itemstack.func_77978_p().func_74762_e(ItemRoadUpdater.RADIUS_KEY);
                String fromBlockName = MODES[mode][0];
                String toBlockName = MODES[mode][1];
                Block fromBlock = Block.func_149684_b((String)fromBlockName);
                Block toBlock = Block.func_149684_b((String)toBlockName);
                if (fromBlock != null && toBlock != null) {
                    list.add(Dateiverwaltung.sucess + "Aktueller Modus: " + mode);
                    list.add(Dateiverwaltung.warning + "Von: " + fromBlockName);
                    list.add(Dateiverwaltung.warning + "Zu: " + toBlockName);
                    list.add(Dateiverwaltung.sucess + "Aktueller Radius: " + radius);
                } else {
                    list.add(Dateiverwaltung.error + "Fehler: Ung\ufffdltige Bl\ufffdcke im Modus " + mode);
                }
            }
        }

        public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                if (!world.field_72995_K) {
                    ItemRoadUpdater.undoUpdate(world, itemstack);
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Letzte \ufffdnderung r\ufffdckg\ufffdngig gemacht"), true);
                }
            } else if (!world.field_72995_K && itemstack.func_77942_o()) {
                int mode = itemstack.func_77978_p().func_74762_e(ItemRoadUpdater.MODE_KEY);
                int radius = itemstack.func_77978_p().func_74762_e(ItemRoadUpdater.RADIUS_KEY);
                String fromBlockName = MODES[mode][0];
                String toBlockName = MODES[mode][1];
                Block fromBlock = Block.func_149684_b((String)fromBlockName);
                Block toBlock = Block.func_149684_b((String)toBlockName);
                if (fromBlock != null && toBlock != null) {
                    RayTraceResult rayTraceResult = this.func_77621_a(world, player, true);
                    if (rayTraceResult != null && rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK) {
                        BlockPos pos = rayTraceResult.func_178782_a();
                        IBlockState state = world.func_180495_p(pos);
                        int fromMeta = fromBlock.func_176201_c(state);
                        ItemRoadUpdater.updateBlocks(world, pos, fromBlock, toBlock, fromMeta, itemstack);
                        player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Bl\ufffdcke im " + (radius * 2 + 1) + "x" + (radius * 2 + 1) + " Radius aktualisiert"), true);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.error + "Fehler: Ung\ufffdltige Bl\ufffdcke im Modus " + mode), true);
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
    }
}

