/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.keybinds;

import de.sarocesch.minewacheroleplaymod.keybinds.KeyBindingFlyDown;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.world.GameType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SpectatorKeySwap {
    private static boolean swapped = false;
    private static int origSneakCode = 0;
    private static int origFlyDownCode = 0;
    private static boolean spectatorActive = false;
    private static boolean autoApplied = false;

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new SpectatorKeySwap());
    }

    public static boolean isSpectatorActive() {
        return spectatorActive;
    }

    public static int getOriginalFlyDownKeyCode() {
        return origFlyDownCode;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        boolean isSpectator;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null) {
            return;
        }
        PlayerControllerMP ctrl = mc.field_71442_b;
        spectatorActive = isSpectator = ctrl != null && ctrl.func_178889_l() == GameType.SPECTATOR || mc.field_71439_g.func_175149_v();
        KeyBinding sneak = mc.field_71474_y.field_74311_E;
        KeyBinding flyDown = KeyBindingFlyDown.KEY_FLYDOWN;
        if (flyDown == null) {
            return;
        }
        if (isSpectator && !swapped) {
            origSneakCode = sneak.func_151463_i();
            origFlyDownCode = flyDown.func_151463_i();
            sneak.func_151462_b(origFlyDownCode);
            flyDown.func_151462_b(origSneakCode);
            KeyBinding.func_74508_b();
            swapped = true;
            SpectatorKeySwap.trySendVanish(mc, true);
        } else if (!isSpectator && swapped) {
            sneak.func_151462_b(origSneakCode);
            flyDown.func_151462_b(origFlyDownCode);
            KeyBinding.func_74508_b();
            swapped = false;
            if (autoApplied) {
                SpectatorKeySwap.trySendVanish(mc, false);
            }
        }
    }

    private static void trySendVanish(Minecraft mc, boolean enteringSpectator) {
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        mc.field_71439_g.func_71165_d("/vanish");
        autoApplied = enteringSpectator;
    }
}

