/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.navi.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandNaviCords
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Map<EntityPlayerMP, BlockPos> playerTargets = new HashMap<EntityPlayerMP, BlockPos>();
    private static final Map<EntityPlayerMP, List<BlockPos>> playerPaths = new HashMap<EntityPlayerMP, List<BlockPos>>();
    private static final int DEFAULT_UPDATE_INTERVAL = 10;
    private static final int updateInterval = 10;
    private static int tickCounter = 0;

    public CommandNaviCords(ElementsMinewacheRolePlayMod instance) {
        super(instance, 311);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (++tickCounter >= 10) {
            tickCounter = 0;
            Iterator<Map.Entry<EntityPlayerMP, BlockPos>> iterator = playerTargets.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<EntityPlayerMP, BlockPos> entry = iterator.next();
                EntityPlayerMP player = entry.getKey();
                BlockPos targetPos = entry.getValue();
                BlockPos playerPos = player.func_180425_c();
                if (CommandNaviCords.isWithinHoverRange(playerPos, targetPos)) {
                    iterator.remove();
                    playerPaths.remove(player);
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Ziel Erreicht!"), true);
                    continue;
                }
                boolean onPath = CommandNaviCords.isBlockNavigable(player.func_130014_f_(), playerPos);
                if (!onPath) {
                    List<BlockPos> originalPath = playerPaths.get(player);
                    if (originalPath != null) {
                        CommandNaviCords.displayParticles(player, originalPath);
                    }
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Du hast die Route verlassen!"), true);
                    continue;
                }
                List<BlockPos> path = CommandNaviCords.findPath(player.func_130014_f_(), playerPos, targetPos);
                if (path == null) {
                    iterator.remove();
                    playerPaths.remove(player);
                    continue;
                }
                playerPaths.put(player, path);
                CommandNaviCords.displayParticles(player, path);
                int remainingBlocks = path.size();
                player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.standard + "Ziel in " + remainingBlocks + " Metern"), true);
            }
        }
    }

    private static boolean isWithinHoverRange(BlockPos playerPos, BlockPos targetPos) {
        int range = 3;
        return Math.abs(playerPos.func_177958_n() - targetPos.func_177958_n()) <= range && Math.abs(playerPos.func_177952_p() - targetPos.func_177952_p()) <= range && playerPos.func_177956_o() >= targetPos.func_177956_o() && playerPos.func_177956_o() <= targetPos.func_177956_o() + range;
    }

    private static List<BlockPos> findPath(World world, BlockPos start, BlockPos goal) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        HashMap<BlockPos, BlockPos> cameFrom = new HashMap<BlockPos, BlockPos>();
        queue.add(start);
        cameFrom.put(start, null);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (current.equals((Object)goal)) {
                ArrayList<BlockPos> path = new ArrayList<BlockPos>();
                BlockPos step = goal;
                while (step != null) {
                    path.add(step);
                    step = (BlockPos)cameFrom.get(step);
                }
                Collections.reverse(path);
                return path;
            }
            for (BlockPos neighbor : CommandNaviCords.getNeighbors(world, current)) {
                if (cameFrom.containsKey(neighbor) || !CommandNaviCords.isBlockNavigable(world, neighbor)) continue;
                queue.add(neighbor);
                cameFrom.put(neighbor, current);
            }
        }
        return null;
    }

    private static List<BlockPos> getNeighbors(World world, BlockPos pos) {
        ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
        neighbors.add(pos.func_177978_c());
        neighbors.add(pos.func_177968_d());
        neighbors.add(pos.func_177974_f());
        neighbors.add(pos.func_177976_e());
        neighbors.add(pos.func_177984_a());
        neighbors.add(pos.func_177977_b());
        return neighbors;
    }

    private static boolean isBlockNavigable(World world, BlockPos pos) {
        for (int i = 0; i <= 3; ++i) {
            IBlockState state = world.func_180495_p(pos.func_177979_c(i));
            Block block = state.func_177230_c();
            ResourceLocation blockName = block.getRegistryName();
            if (blockName == null || !Dateiverwaltung.NaviItems.contains(blockName.toString())) continue;
            return true;
        }
        return false;
    }

    private static void displayParticles(EntityPlayerMP player, List<BlockPos> path) {
        for (BlockPos pos : path) {
            BlockPos highestPos = CommandNaviCords.getHighestBlockPos(player.func_130014_f_(), pos);
            Vec3d point = new Vec3d((double)highestPos.func_177958_n() + 0.5, (double)highestPos.func_177956_o() + 1.0, (double)highestPos.func_177952_p() + 0.5);
            SPacketParticles packet = new SPacketParticles(EnumParticleTypes.END_ROD, false, (float)point.field_72450_a, (float)point.field_72448_b, (float)point.field_72449_c, 0.0f, 0.0f, 0.0f, 0.01f, 1, null);
            player.field_71135_a.func_147359_a((Packet)packet);
        }
    }

    private static BlockPos getHighestBlockPos(World world, BlockPos pos) {
        BlockPos currentPos = pos;
        while (!world.func_175623_d(currentPos.func_177984_a())) {
            currentPos = currentPos.func_177984_a();
        }
        return currentPos;
    }

    public static Map<EntityPlayerMP, BlockPos> getPlayerTargets() {
        return playerTargets;
    }

    public static Map<EntityPlayerMP, List<BlockPos>> getPlayerPaths() {
        return playerPaths;
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private static boolean isBlockNavigable(World world, BlockPos pos) {
            for (int i = 0; i <= 3; ++i) {
                IBlockState state = world.func_180495_p(pos.func_177979_c(i));
                Block block = state.func_177230_c();
                ResourceLocation blockName = block.getRegistryName();
                if (blockName == null || !Dateiverwaltung.NaviItems.contains(blockName.toString())) continue;
                return true;
            }
            return false;
        }

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender var1) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public String func_71517_b() {
            return "navicords";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/navicords <x> <y> <z>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length != 3) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /navi <x> <y> <z>"));
                return;
            }
            try {
                int x = Integer.parseInt(args[0]);
                int y = Integer.parseInt(args[1]);
                int z = Integer.parseInt(args[2]);
                BlockPos targetPos = new BlockPos(x, y, z);
                EntityPlayerMP player = (EntityPlayerMP)sender.func_174793_f();
                World world = player.func_130014_f_();
                playerTargets.put(player, targetPos);
                BlockPos playerPos = player.func_180425_c();
                IBlockState playerBlockState = world.func_180495_p(playerPos.func_177977_b());
                Block playerBlock = playerBlockState.func_177230_c();
                ResourceLocation playerBlockName = playerBlock.getRegistryName();
                if (playerPos.equals((Object)targetPos)) {
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.standard + "Du bist bereits am Ziel!"), true);
                    return;
                }
                if (playerBlockName != null && Dateiverwaltung.NaviItems.contains(playerBlockName.toString())) {
                    List<BlockPos> path = this.findPath(world, player.func_180425_c(), targetPos);
                    if (path == null) {
                        player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Keine Route!"), true);
                        playerTargets.remove(player);
                        playerPaths.remove(player);
                    } else {
                        playerPaths.put(player, path);
                    }
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Du musst auf einer Stra\ufffde stehen!"), true);
                    playerTargets.remove(player);
                    playerPaths.remove(player);
                }
            }
            catch (NumberFormatException e) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Ung\ufffdltige Cords"));
            }
        }

        private List<BlockPos> findPath(World world, BlockPos start, BlockPos goal) {
            LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
            HashMap<BlockPos, BlockPos> cameFrom = new HashMap<BlockPos, BlockPos>();
            queue.add(start);
            cameFrom.put(start, null);
            while (!queue.isEmpty()) {
                BlockPos current = (BlockPos)queue.poll();
                if (current.equals((Object)goal)) {
                    ArrayList<BlockPos> path = new ArrayList<BlockPos>();
                    BlockPos step = goal;
                    while (step != null) {
                        path.add(step);
                        step = (BlockPos)cameFrom.get(step);
                    }
                    Collections.reverse(path);
                    return path;
                }
                for (BlockPos neighbor : this.getNeighbors(world, current)) {
                    if (cameFrom.containsKey(neighbor) || !CommandHandler.isBlockNavigable(world, neighbor)) continue;
                    queue.add(neighbor);
                    cameFrom.put(neighbor, current);
                }
            }
            return null;
        }

        private List<BlockPos> getNeighbors(World world, BlockPos pos) {
            ArrayList<BlockPos> neighbors = new ArrayList<BlockPos>();
            neighbors.add(pos.func_177978_c());
            neighbors.add(pos.func_177968_d());
            neighbors.add(pos.func_177974_f());
            neighbors.add(pos.func_177976_e());
            neighbors.add(pos.func_177984_a());
            neighbors.add(pos.func_177977_b());
            return neighbors;
        }
    }
}

