/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.item.ItemAusweis;
import de.sarocesch.minewacheroleplaymod.item.ItemAusweisw;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSubmitAusweisData
implements IMessage {
    private String firstName;
    private String lastName;
    private String date;
    private String height;
    private String sex;
    private String idNumber;

    public PacketSubmitAusweisData() {
    }

    public PacketSubmitAusweisData(String firstName, String lastName, String date, String height, String sex, String idNumber) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.date = date;
        this.height = height;
        this.sex = sex;
        this.idNumber = idNumber;
    }

    private static void writeString(ByteBuf buf, String s) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public void toBytes(ByteBuf buf) {
        PacketSubmitAusweisData.writeString(buf, this.firstName);
        PacketSubmitAusweisData.writeString(buf, this.lastName);
        PacketSubmitAusweisData.writeString(buf, this.date);
        PacketSubmitAusweisData.writeString(buf, this.height);
        PacketSubmitAusweisData.writeString(buf, this.sex);
        PacketSubmitAusweisData.writeString(buf, this.idNumber);
    }

    public void fromBytes(ByteBuf buf) {
        this.firstName = PacketSubmitAusweisData.readString(buf);
        this.lastName = PacketSubmitAusweisData.readString(buf);
        this.date = PacketSubmitAusweisData.readString(buf);
        this.height = PacketSubmitAusweisData.readString(buf);
        this.sex = PacketSubmitAusweisData.readString(buf);
        this.idNumber = PacketSubmitAusweisData.readString(buf);
    }

    public static class Handler
    implements IMessageHandler<PacketSubmitAusweisData, IMessage> {
        public IMessage onMessage(PacketSubmitAusweisData message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                if (PacketSubmitAusweisData.isBlank(message.firstName) || PacketSubmitAusweisData.isBlank(message.lastName) || PacketSubmitAusweisData.isBlank(message.date) || PacketSubmitAusweisData.isBlank(message.height) || PacketSubmitAusweisData.isBlank(message.sex)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cUng\u00fcltige Eingabe. Bitte f\u00fclle alle Felder aus."));
                    return;
                }
                if (!Pattern.matches("[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df-]+", message.firstName) || !Pattern.matches("[a-zA-Z\u00e4\u00f6\u00fc\u00c4\u00d6\u00dc\u00df-]+", message.lastName)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cVor- und Nachname d\u00fcrfen nur Buchstaben enthalten."));
                    return;
                }
                if (!Pattern.matches("\\d{2}\\.\\d{2}\\.\\d{4}", message.date)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7cGeburtsdatum muss im Format TT.MM.JJJJ sein."));
                    return;
                }
                String normalizedHeight = message.height.trim().replace(',', '.');
                if (!Pattern.matches("\\d{1}\\.\\d{2}", normalizedHeight) && !Pattern.matches("\\d{1}\\.\\d{1}", normalizedHeight)) {
                    normalizedHeight = message.height.trim();
                }
                String sex = "w".equalsIgnoreCase(message.sex) ? "w" : "m";
                ItemStack ausweis = new ItemStack("w".equalsIgnoreCase(sex) ? ItemAusweisw.block : ItemAusweis.block);
                NBTTagCompound nbt = new NBTTagCompound();
                List<String> lore = Arrays.asList(message.firstName, message.lastName, message.date, normalizedHeight, sex, message.idNumber == null ? "" : message.idNumber);
                nbt.func_74778_a("AusweisData", String.join((CharSequence)",", lore));
                ausweis.func_77982_d(nbt);
                if (!player.func_191521_c(ausweis)) {
                    player.func_71019_a(ausweis, false);
                }
                player.func_145747_a((ITextComponent)new TextComponentString("\u00a7aAusweis erstellt."));
            });
            return null;
        }
    }
}

