/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.texture.ClientTextureCache;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTextureChunk
implements IMessage {
    public String name;
    public int index;
    public int total;
    public byte[] data;

    public PacketTextureChunk() {
    }

    public PacketTextureChunk(String name, int index, int total, byte[] data) {
        this.name = name;
        this.index = index;
        this.total = total;
        this.data = data;
    }

    public void toBytes(ByteBuf buf) {
        byte[] nb = this.name.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(nb.length);
        buf.writeBytes(nb);
        buf.writeInt(this.index);
        buf.writeInt(this.total);
        buf.writeInt(this.data.length);
        buf.writeBytes(this.data);
    }

    public void fromBytes(ByteBuf buf) {
        int nl = buf.readInt();
        byte[] nb = new byte[nl];
        buf.readBytes(nb);
        this.name = new String(nb, StandardCharsets.UTF_8);
        this.index = buf.readInt();
        this.total = buf.readInt();
        int dl = buf.readInt();
        this.data = new byte[dl];
        buf.readBytes(this.data);
    }

    public static class Handler
    implements IMessageHandler<PacketTextureChunk, IMessage> {
        public IMessage onMessage(PacketTextureChunk msg, MessageContext ctx) {
            ClientTextureCache.onChunk(msg.name, msg.index, msg.total, msg.data);
            return null;
        }
    }
}

