/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.texture.ClientTextureCache;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketTextureManifest
implements IMessage {
    public List<String> names = new ArrayList<String>();

    public PacketTextureManifest() {
    }

    public PacketTextureManifest(List<String> names) {
        this.names = names;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.names.size());
        for (String n : this.names) {
            byte[] b = n.getBytes(StandardCharsets.UTF_8);
            buf.writeInt(b.length);
            buf.writeBytes(b);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int sz = buf.readInt();
        this.names = new ArrayList<String>(sz);
        for (int i = 0; i < sz; ++i) {
            int len = buf.readInt();
            byte[] b = new byte[len];
            buf.readBytes(b);
            this.names.add(new String(b, StandardCharsets.UTF_8));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketTextureManifest, IMessage> {
        public IMessage onMessage(PacketTextureManifest msg, MessageContext ctx) {
            ClientTextureCache.onManifest(msg.names);
            return null;
        }
    }
}

