/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class PngNetworkHandler
extends ElementsMinewacheRolePlayMod.ModElement {
    public static final SimpleNetworkWrapper INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("png_channel");

    public PngNetworkHandler(ElementsMinewacheRolePlayMod instance) {
        super(instance, 396);
    }

    public static void registerMessages() {
        INSTANCE.registerMessage(PngPacketHandler.class, PngPacket.class, 0, Side.CLIENT);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        PngNetworkHandler.registerMessages();
    }

    public static class PngPacketHandler
    implements IMessageHandler<PngPacket, IMessage> {
        public IMessage onMessage(PngPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                try {
                    File gameDir = Minecraft.func_71410_x().field_71412_D;
                    File mapsDir = new File(gameDir, "maps");
                    if (!mapsDir.exists()) {
                        mapsDir.mkdirs();
                    }
                    File file = new File(mapsDir, message.filename);
                    Files.write(file.toPath(), message.data, new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            return null;
        }
    }

    public static class PngPacket
    implements IMessage {
        private String filename;
        private byte[] data;

        public PngPacket() {
        }

        public PngPacket(String filename, byte[] data) {
            this.filename = filename;
            this.data = data;
        }

        public void fromBytes(ByteBuf buf) {
            this.filename = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.data = new byte[buf.readInt()];
            buf.readBytes(this.data);
        }

        public void toBytes(ByteBuf buf) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.filename);
            buf.writeInt(this.data.length);
            buf.writeBytes(this.data);
        }
    }
}

