/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPhoneInitialSync
implements IMessage {
    public Map<String, String> nicknames = new HashMap<String, String>();
    public Map<String, Boolean> online = new HashMap<String, Boolean>();
    public Map<String, Long> lastSeen = new HashMap<String, Long>();
    public boolean darkTheme;
    public float scale;
    public boolean sounds;
    public String privacy;
    public boolean readReceipts;
    public String background;

    public void toBytes(ByteBuf buf) {
        PacketPhoneInitialSync.writeMapString(buf, this.nicknames);
        PacketPhoneInitialSync.writeMapBool(buf, this.online);
        PacketPhoneInitialSync.writeMapLong(buf, this.lastSeen);
        buf.writeBoolean(this.darkTheme);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.sounds);
        PacketPhoneInitialSync.writeString(buf, this.privacy);
        buf.writeBoolean(this.readReceipts);
        PacketPhoneInitialSync.writeString(buf, this.background != null ? this.background : "default_dark.png");
    }

    public void fromBytes(ByteBuf buf) {
        this.nicknames = PacketPhoneInitialSync.readMapString(buf);
        this.online = PacketPhoneInitialSync.readMapBool(buf);
        this.lastSeen = PacketPhoneInitialSync.readMapLong(buf);
        this.darkTheme = buf.readBoolean();
        this.scale = buf.readFloat();
        this.sounds = buf.readBoolean();
        this.privacy = PacketPhoneInitialSync.readString(buf);
        this.readReceipts = buf.readBoolean();
        this.background = PacketPhoneInitialSync.readString(buf);
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    private static void writeMapString(ByteBuf buf, Map<String, String> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, String> e : map.entrySet()) {
            PacketPhoneInitialSync.writeString(buf, e.getKey());
            PacketPhoneInitialSync.writeString(buf, e.getValue());
        }
    }

    private static Map<String, String> readMapString(ByteBuf buf) {
        int n = buf.readInt();
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            map.put(PacketPhoneInitialSync.readString(buf), PacketPhoneInitialSync.readString(buf));
        }
        return map;
    }

    private static void writeMapBool(ByteBuf buf, Map<String, Boolean> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, Boolean> e : map.entrySet()) {
            PacketPhoneInitialSync.writeString(buf, e.getKey());
            buf.writeBoolean(e.getValue().booleanValue());
        }
    }

    private static Map<String, Boolean> readMapBool(ByteBuf buf) {
        int n = buf.readInt();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        for (int i = 0; i < n; ++i) {
            map.put(PacketPhoneInitialSync.readString(buf), buf.readBoolean());
        }
        return map;
    }

    private static void writeMapLong(ByteBuf buf, Map<String, Long> map) {
        buf.writeInt(map.size());
        for (Map.Entry<String, Long> e : map.entrySet()) {
            PacketPhoneInitialSync.writeString(buf, e.getKey());
            buf.writeLong(e.getValue().longValue());
        }
    }

    private static Map<String, Long> readMapLong(ByteBuf buf) {
        int n = buf.readInt();
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < n; ++i) {
            map.put(PacketPhoneInitialSync.readString(buf), buf.readLong());
        }
        return map;
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneInitialSync, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPhoneInitialSync msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                PhoneClientState.nicknames.clear();
                PhoneClientState.nicknames.putAll(msg.nicknames);
                PhoneClientState.online.clear();
                PhoneClientState.online.putAll(msg.online);
                PhoneClientState.lastSeen.clear();
                PhoneClientState.lastSeen.putAll(msg.lastSeen);
                PhoneClientState.settings.darkTheme = msg.darkTheme;
                PhoneClientState.settings.scale = msg.scale;
                PhoneClientState.settings.sounds = msg.sounds;
                PhoneClientState.settings.privacy = msg.privacy;
                PhoneClientState.settings.readReceipts = msg.readReceipts;
                PhoneClientState.settings.background = msg.background;
            });
            return null;
        }
    }
}

