/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.imageio.ImageIO;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPhonePhotoThumb
implements IMessage {
    public String id;
    public byte[] png;

    public PacketPhonePhotoThumb() {
    }

    public PacketPhonePhotoThumb(String id, byte[] png) {
        this.id = id;
        this.png = png;
    }

    public void toBytes(ByteBuf buf) {
        PacketPhonePhotoThumb.writeString(buf, this.id);
        buf.writeInt(this.png != null ? this.png.length : 0);
        if (this.png != null) {
            buf.writeBytes(this.png);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.id = PacketPhonePhotoThumb.readString(buf);
        int n = buf.readInt();
        this.png = new byte[n];
        if (n > 0) {
            buf.readBytes(this.png);
        }
    }

    static void writeString(ByteBuf buf, String s) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    static String readString(ByteBuf buf) {
        int l = buf.readUnsignedShort();
        byte[] b = new byte[l];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhonePhotoThumb, IMessage> {
        public IMessage onMessage(PacketPhonePhotoThumb msg, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                try {
                    BufferedImage bi;
                    if (msg.png != null && msg.png.length > 0 && (bi = ImageIO.read(new ByteArrayInputStream(msg.png))) != null) {
                        PhoneClientState.putThumb(msg.id, bi);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return null;
        }
    }
}

