/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPhonePhotosList
implements IMessage {
    public List<Photo> list = new ArrayList<Photo>();

    public void toBytes(ByteBuf buf) {
        buf.writeShort(this.list.size());
        for (Photo p : this.list) {
            PacketPhonePhotosList.writeString(buf, p.id);
            buf.writeLong(p.ts);
            buf.writeInt(p.w);
            buf.writeInt(p.h);
            PacketPhonePhotosList.writeString(buf, p.name);
        }
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readUnsignedShort();
        this.list = new ArrayList<Photo>(n);
        for (int i = 0; i < n; ++i) {
            Photo p = new Photo();
            p.id = PacketPhonePhotosList.readString(buf);
            p.ts = buf.readLong();
            p.w = buf.readInt();
            p.h = buf.readInt();
            p.name = PacketPhonePhotosList.readString(buf);
            this.list.add(p);
        }
    }

    static void writeString(ByteBuf buf, String s) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    static String readString(ByteBuf buf) {
        int l = buf.readUnsignedShort();
        byte[] b = new byte[l];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhonePhotosList, IMessage> {
        public IMessage onMessage(PacketPhonePhotosList msg, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> {
                PhoneClientState.photos.clear();
                for (Photo p : msg.list) {
                    PhoneClientState.PhotoMeta m = new PhoneClientState.PhotoMeta();
                    m.id = p.id;
                    m.ts = p.ts;
                    m.w = p.w;
                    m.h = p.h;
                    m.name = p.name;
                    PhoneClientState.photos.add(m);
                }
            });
            return null;
        }
    }

    public static class Photo {
        public String id;
        public long ts;
        public int w;
        public int h;
        public String name;
    }
}

