/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class PhonePresenceData
extends WorldSavedData {
    public static final String DATA_NAME = "mw_phone_presence";
    private final Map<String, Long> lastSeen = new HashMap<String, Long>();

    public PhonePresenceData() {
        super(DATA_NAME);
    }

    public PhonePresenceData(String name) {
        super(name);
    }

    public static PhonePresenceData get(World world) {
        if (world == null) {
            return null;
        }
        MapStorage storage = world.getPerWorldStorage();
        PhonePresenceData data = (PhonePresenceData)storage.func_75742_a(PhonePresenceData.class, DATA_NAME);
        if (data == null) {
            data = new PhonePresenceData();
            storage.func_75745_a(DATA_NAME, (WorldSavedData)data);
        }
        return data;
    }

    public Map<String, Long> getLastSeen() {
        return Collections.unmodifiableMap(this.lastSeen);
    }

    public void markSeen(String playerName, long ts) {
        if (playerName == null) {
            return;
        }
        this.lastSeen.put(playerName, ts);
        this.func_76185_a();
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.lastSeen.clear();
        NBTTagCompound ls = nbt.func_74775_l("lastSeen");
        for (String k : ls.func_150296_c()) {
            this.lastSeen.put(k, ls.func_74763_f(k));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagCompound ls = new NBTTagCompound();
        for (Map.Entry<String, Long> e : this.lastSeen.entrySet()) {
            ls.func_74772_a(e.getKey(), e.getValue().longValue());
        }
        compound.func_74782_a("lastSeen", (NBTBase)ls);
        return compound;
    }
}

