/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.registration;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.registration.ModRegistrationManager;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

public class BlockRegistrationHelper {
    public static void registerBlockWithItem(@Nonnull ElementsMinewacheRolePlayMod elements, @Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier) {
        BlockRegistrationHelper.registerBlockWithItem(elements, registryName, blockSupplier, null);
    }

    public static void registerBlockWithItem(@Nonnull ElementsMinewacheRolePlayMod elements, @Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier, @Nullable String modelLocation) {
        ModRegistrationManager.registerBlock(registryName, blockSupplier, true, modelLocation);
    }

    public static void registerBlockOnly(@Nonnull ElementsMinewacheRolePlayMod elements, @Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier) {
        ModRegistrationManager.registerBlock(registryName, blockSupplier, false, null);
        elements.blocks.add(() -> {
            Block block = (Block)blockSupplier.get();
            if (block != null) {
                block.setRegistryName(registryName);
            }
            return block;
        });
    }

    @Nullable
    public static Block getBlockSafely(@Nonnull String registryName) {
        return ModRegistrationManager.getBlock(registryName);
    }

    @Nullable
    public static Item getItemSafely(@Nonnull String registryName) {
        return ModRegistrationManager.getItem(registryName);
    }

    public static boolean isBlockRegistered(@Nonnull String registryName) {
        return ModRegistrationManager.getBlock(registryName) != null;
    }

    public static boolean isItemRegistered(@Nonnull String registryName) {
        return ModRegistrationManager.getItem(registryName) != null;
    }
}

