/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.registration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="saros_new_blocks_mod")
public class ModRegistrationManager {
    private static final List<BlockRegistration> BLOCK_REGISTRATIONS = new ArrayList<BlockRegistration>();
    private static final Map<String, Block> REGISTERED_BLOCKS = new HashMap<String, Block>();
    private static final Map<String, Item> REGISTERED_ITEMS = new HashMap<String, Item>();

    public static void registerBlock(@Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier) {
        ModRegistrationManager.registerBlock(registryName, blockSupplier, true, null);
    }

    public static void registerBlock(@Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier, boolean hasItemBlock, @Nullable String modelLocation) {
        BLOCK_REGISTRATIONS.add(new BlockRegistration(registryName, blockSupplier, hasItemBlock, modelLocation));
    }

    @Nullable
    public static Block getBlock(@Nonnull String registryName) {
        return REGISTERED_BLOCKS.get(registryName);
    }

    @Nullable
    public static Item getItem(@Nonnull String registryName) {
        return REGISTERED_ITEMS.get(registryName);
    }

    @SubscribeEvent
    public static void onBlockRegister(@Nonnull RegistryEvent.Register<Block> event) {
        for (BlockRegistration registration : BLOCK_REGISTRATIONS) {
            try {
                Block block = registration.blockSupplier.get();
                if (block != null) {
                    block.setRegistryName(new ResourceLocation("saros_new_blocks_mod", registration.registryName));
                    event.getRegistry().register((IForgeRegistryEntry)block);
                    REGISTERED_BLOCKS.put(registration.registryName, block);
                    System.out.println("[ModRegistrationManager] Registered block: " + registration.registryName);
                    continue;
                }
                System.err.println("[ModRegistrationManager] Failed to create block: " + registration.registryName + " (supplier returned null)");
            }
            catch (Exception e) {
                System.err.println("[ModRegistrationManager] Error registering block " + registration.registryName + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onItemRegister(@Nonnull RegistryEvent.Register<Item> event) {
        for (BlockRegistration registration : BLOCK_REGISTRATIONS) {
            if (!registration.hasItemBlock) continue;
            try {
                Block block = REGISTERED_BLOCKS.get(registration.registryName);
                if (block != null) {
                    ItemBlock itemBlock = new ItemBlock(block);
                    itemBlock.setRegistryName(new ResourceLocation("saros_new_blocks_mod", registration.registryName));
                    event.getRegistry().register((IForgeRegistryEntry)itemBlock);
                    REGISTERED_ITEMS.put(registration.registryName, (Item)itemBlock);
                    System.out.println("[ModRegistrationManager] Registered item for block: " + registration.registryName);
                    continue;
                }
                System.err.println("[ModRegistrationManager] Cannot create ItemBlock for " + registration.registryName + " - block not found");
            }
            catch (Exception e) {
                System.err.println("[ModRegistrationManager] Error registering item for block " + registration.registryName + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onModelRegister(@Nonnull ModelRegistryEvent event) {
        for (BlockRegistration registration : BLOCK_REGISTRATIONS) {
            if (!registration.hasItemBlock) continue;
            try {
                Item item = REGISTERED_ITEMS.get(registration.registryName);
                if (item != null) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(registration.modelLocation, "inventory"));
                    System.out.println("[ModRegistrationManager] Registered model for: " + registration.registryName);
                    continue;
                }
                System.err.println("[ModRegistrationManager] Cannot register model for " + registration.registryName + " - item not found");
            }
            catch (Exception e) {
                System.err.println("[ModRegistrationManager] Error registering model for " + registration.registryName + ": " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void clearRegistrations() {
        BLOCK_REGISTRATIONS.clear();
        REGISTERED_BLOCKS.clear();
        REGISTERED_ITEMS.clear();
    }

    public static int getRegisteredBlockCount() {
        return REGISTERED_BLOCKS.size();
    }

    public static int getRegisteredItemCount() {
        return REGISTERED_ITEMS.size();
    }

    public static class BlockRegistration {
        public final String registryName;
        public final Supplier<Block> blockSupplier;
        public final boolean hasItemBlock;
        public final String modelLocation;

        public BlockRegistration(@Nonnull String registryName, @Nonnull Supplier<Block> blockSupplier, boolean hasItemBlock, @Nullable String modelLocation) {
            this.registryName = registryName;
            this.blockSupplier = blockSupplier;
            this.hasItemBlock = hasItemBlock;
            this.modelLocation = modelLocation != null ? modelLocation : "saros_new_blocks_mod:" + registryName;
        }
    }
}

