/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.texture;

import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiStorage;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.PacketTextureChunk;
import de.sarocesch.minewacheroleplaymod.network.PacketTextureManifest;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerTextureSync {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ServerTextureSync());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        try {
            File dir = CustomGuiStorage.getTextureDir();
            File[] files = dir.listFiles((d, name) -> name.toLowerCase().endsWith(".png"));
            ArrayList<String> names = new ArrayList<String>();
            if (files != null) {
                for (File f : files) {
                    names.add(f.getName());
                }
            }
            NetworkHandler.INSTANCE.sendTo((IMessage)new PacketTextureManifest(names), player);
            if (files != null) {
                for (File f : files) {
                    byte[] all = Files.readAllBytes(f.toPath());
                    int chunkSize = 32768;
                    int total = (all.length + chunkSize - 1) / chunkSize;
                    for (int i = 0; i < total; ++i) {
                        int start = i * chunkSize;
                        int end = Math.min(start + chunkSize, all.length);
                        byte[] part = Arrays.copyOfRange(all, start, end);
                        NetworkHandler.INSTANCE.sendTo((IMessage)new PacketTextureChunk(f.getName(), i, total, part), player);
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

