/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandBlockitem
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandBlockitem(ElementsMinewacheRolePlayMod instance) {
        super(instance, 334);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private static List<String> getBlockedItems() {
            ArrayList<String> blockedItems = new ArrayList<String>();
            File file = new File("blockeditems.txt");
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    String registerName = line.trim().split("\\{")[0].replace("{", "").replace("}", "");
                    blockedItems.add(registerName);
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return blockedItems;
        }

        private static List<String> getListOfStringsMatchingLastWord(String[] args, List<String> possibilities) {
            String lastWord = args[args.length - 1];
            ArrayList<String> matches = new ArrayList<String>();
            for (String possibility : possibilities) {
                if (!possibility.startsWith(lastWord)) continue;
                matches.add(possibility);
            }
            return matches;
        }

        private static boolean checkIfRegisterExists(File file, String registerName) {
            List<String> blockedItems = CommandHandler.getBlockedItems();
            return blockedItems.contains(registerName);
        }

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender var1) {
            return true;
        }

        public List func_71514_a() {
            return new ArrayList();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("add");
                completions.add("remove");
                completions.add("whitelist");
                return CommandHandler.getListOfStringsMatchingLastWord(args, completions);
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("remove")) {
                return CommandHandler.getListOfStringsMatchingLastWord(args, CommandHandler.getBlockedItems());
            }
            if (args.length == 2 && args[0].equalsIgnoreCase("whitelist")) {
                return CommandHandler.getListOfStringsMatchingLastWord(args, CommandHandler.getBlockedItems());
            }
            if (args.length == 3 && args[0].equalsIgnoreCase("whitelist")) {
                List<String> playerAndTeamNames = this.getPlayerAndTeamNames(server);
                return CommandHandler.getListOfStringsMatchingLastWord(args, playerAndTeamNames);
            }
            return Collections.emptyList();
        }

        private List<String> getPlayerAndTeamNames(MinecraftServer server) {
            ArrayList<String> playerAndTeamNames = new ArrayList<String>();
            File teamDirectory = new File("config/minewache/mw-teams/");
            File[] teamFiles = teamDirectory.listFiles();
            if (teamFiles != null) {
                for (File teamFile : teamFiles) {
                    if (!teamFile.isFile()) continue;
                    String teamName = teamFile.getName().replace(".txt", "");
                    playerAndTeamNames.add(teamName);
                }
            }
            return playerAndTeamNames;
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "blockitem";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/blockitem";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            if (!(cmd[0].equalsIgnoreCase("add") || cmd[0].equalsIgnoreCase("remove") || cmd[0].equalsIgnoreCase("whitelist"))) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /blockitem <add/remove/whitelist>"));
                return;
            }
            if (!(sender instanceof EntityPlayerMP)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "This command can only be executed by players."));
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)sender;
            ItemStack heldItem = player.func_184614_ca();
            String registerName = heldItem.func_77973_b().getRegistryName().toString();
            File file = new File("blockeditems.txt");
            if (cmd[0].equalsIgnoreCase("add")) {
                if (heldItem.func_190926_b()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Hold an item in your hand to >add< it from the blocked list."));
                    return;
                }
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    while ((line = reader.readLine()) != null) {
                        if (!line.trim().equals(registerName + "{")) continue;
                        reader.close();
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Item already exists in the blocked list."));
                        return;
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "An error occurred while checking the blocked list."));
                    return;
                }
                try {
                    FileWriter writer = new FileWriter(file, true);
                    writer.write(registerName + "{\n}\n");
                    writer.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Item added to blocked list: " + registerName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "An error occurred while adding the item to the blocked list."));
                }
            } else if (cmd[0].equalsIgnoreCase("whitelist")) {
                if (cmd.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /blockitem whitelist <registerName> <playerOrTeamName1> [playerOrTeamName2, ...]"));
                    return;
                }
                String whitelistRegisterName = cmd[1];
                boolean alreadyExists = CommandHandler.checkIfRegisterExists(file, whitelistRegisterName);
                if (!alreadyExists) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Das Element wurde nicht in der Blockierungsliste gefunden. Bitte f\ufffdge es zuerst hinzu."));
                    return;
                }
                boolean nameAlreadyExists = false;
                for (int i = 2; i < cmd.length; ++i) {
                    String playerNameOrTeamName = cmd[i];
                    if (!this.checkIfNameExistsInWhitelist(file, whitelistRegisterName, playerNameOrTeamName)) continue;
                    nameAlreadyExists = true;
                    break;
                }
                if (nameAlreadyExists) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Ein Spieler oder Team ist bereits in der Whitelist f\ufffdr dieses Element."));
                    return;
                }
                if (cmd.length > 2) {
                    try {
                        String line;
                        BufferedReader reader = new BufferedReader(new FileReader(file));
                        StringBuilder modifiedContent = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            if (line.trim().startsWith(whitelistRegisterName)) {
                                line = line.replace("{", "{ ");
                                for (int i = 2; i < cmd.length; ++i) {
                                    line = line + cmd[i] + "; ";
                                }
                            }
                            modifiedContent.append(line).append("\n");
                        }
                        reader.close();
                        FileWriter writer = new FileWriter(file);
                        writer.write(modifiedContent.toString());
                        writer.close();
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.sucess + "Spieler oder Teamnamen wurden zur Whitelist f\ufffdr das Element hinzugef\ufffdgt: " + whitelistRegisterName));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Beim Hinzuf\ufffdgen von Spieler- oder Teamnamen zur Whitelist ist ein Fehler aufgetreten."));
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Keine Spieler- oder Teamnamen angegeben."));
                }
            } else if (cmd[0].equalsIgnoreCase("remove")) {
                if (cmd.length < 2) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /blockitem remove <registerName>"));
                    return;
                }
                String removeRegisterName = cmd[1];
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    ArrayList<String> lines = new ArrayList<String>();
                    boolean removed = false;
                    while ((line = reader.readLine()) != null) {
                        if (!line.trim().startsWith(removeRegisterName)) {
                            lines.add(line);
                            continue;
                        }
                        removed = true;
                        reader.readLine();
                    }
                    reader.close();
                    if (!removed) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Item not found in the blocked list."));
                        return;
                    }
                    FileWriter writer = new FileWriter(file);
                    for (String item : lines) {
                        writer.write(item + "\n");
                    }
                    writer.close();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Item removed from blocked list: " + removeRegisterName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "An error occurred while removing the item from the blocked list."));
                }
            } else {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Usage: /blockitem <add/remove>"));
            }
        }

        private boolean checkIfNameExistsInWhitelist(File file, String registerName, String name) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(file));
                while ((line = reader.readLine()) != null) {
                    String[] whitelistNames;
                    String[] parts;
                    if (!line.trim().startsWith(registerName) || (parts = line.split("\\{")).length < 2) continue;
                    for (String whitelistName : whitelistNames = parts[1].split("}")[0].split(";")) {
                        if (!whitelistName.trim().equalsIgnoreCase(name)) continue;
                        reader.close();
                        return true;
                    }
                }
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return false;
        }
    }
}

