/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameType;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandGm
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandGm(ElementsMinewacheRolePlayMod instance) {
        super(instance, 253);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private final String standardFarbe = Dateiverwaltung.standard;
        private final String warningFarbe = Dateiverwaltung.warning;
        private final String playernameFarbe = Dateiverwaltung.playername;

        public String func_71517_b() {
            return "gm";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/gm [<gameMode>] [<playerName>]";
        }

        public List<String> func_71514_a() {
            return Collections.emptyList();
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "minewachemod.command.gm");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return Arrays.asList("0", "1", "2", "3");
            }
            if (args.length == 2) {
                PlayerList playerList = server.func_184103_al();
                return CommandBase.func_71530_a((String[])args, (String[])playerList.func_72369_d());
            }
            return Collections.emptyList();
        }

        public boolean func_82358_a(String[] args, int index) {
            return index == 1;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            if (cmd.length > 0) {
                EntityPlayerMP player;
                int gameMode;
                try {
                    gameMode = Integer.parseInt(cmd[0]);
                }
                catch (NumberFormatException e) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.gm.invalid_argument", this.warningFarbe, new Object[0]);
                    return;
                }
                EntityPlayerMP entityPlayerMP = player = cmd.length > 1 ? this.getPlayer(server, cmd[1]) : (EntityPlayerMP)sender.func_174793_f();
                if (player == null) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.gm.player_not_found", this.warningFarbe, cmd[1]);
                    return;
                }
                switch (gameMode) {
                    case 0: {
                        player.func_71033_a(GameType.SURVIVAL);
                        this.sendGameModeMessage(sender, player, "survival");
                        break;
                    }
                    case 1: {
                        player.func_71033_a(GameType.CREATIVE);
                        this.sendGameModeMessage(sender, player, "creative");
                        break;
                    }
                    case 2: {
                        player.func_71033_a(GameType.ADVENTURE);
                        this.sendGameModeMessage(sender, player, "adventure");
                        break;
                    }
                    case 3: {
                        player.func_71033_a(GameType.SPECTATOR);
                        this.sendGameModeMessage(sender, player, "spectator");
                        break;
                    }
                    default: {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.gm.invalid_mode", this.warningFarbe, new Object[0]);
                        break;
                    }
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.gm.no_arguments", this.warningFarbe, new Object[0]);
            }
        }

        private void sendGameModeMessage(ICommandSender sender, EntityPlayerMP player, String mode) {
            LangNetworkHandler.sendTranslationMessage(sender, "command.gm." + mode, this.standardFarbe, this.playernameFarbe + player.func_70005_c_());
        }

        private EntityPlayerMP getPlayer(MinecraftServer server, String playerName) {
            return server.func_184103_al().func_152612_a(playerName);
        }
    }
}

