/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandHome
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandHome(ElementsMinewacheRolePlayMod instance) {
        super(instance, 282);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        public String func_71517_b() {
            return "home";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/home set <name> | delete <name> | <name>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                UUID playerUUID = player.func_110124_au();
                NBTTagCompound playerData = player.getEntityData();
                NBTTagList homeList = playerData.func_150295_c("HomeList", 10);
                if (args.length < 1) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.home.usage", Dateiverwaltung.error, new Object[0]);
                    return;
                }
                String subCommand = args[0];
                if (subCommand.equals("set")) {
                    if (args.length < 2) {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.set.usage", Dateiverwaltung.error, new Object[0]);
                        return;
                    }
                    String homeName = args[1];
                    for (int i = 0; i < homeList.func_74745_c(); ++i) {
                        NBTTagCompound tag = homeList.func_150305_b(i);
                        if (!tag.func_74779_i("Name").equals(homeName)) continue;
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.set.exists", Dateiverwaltung.error, homeName);
                        return;
                    }
                    NBTTagCompound homeTag = new NBTTagCompound();
                    homeTag.func_74778_a("Name", homeName);
                    homeTag.func_74780_a("X", player.field_70165_t);
                    homeTag.func_74780_a("Y", player.field_70163_u);
                    homeTag.func_74780_a("Z", player.field_70161_v);
                    homeList.func_74742_a((NBTBase)homeTag);
                    playerData.func_74782_a("HomeList", (NBTBase)homeList);
                    LangNetworkHandler.sendTranslationMessage(sender, "command.home.set.success", Dateiverwaltung.standard, homeName);
                } else if (subCommand.equals("delete")) {
                    if (args.length < 2) {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.delete.usage", Dateiverwaltung.error, new Object[0]);
                        return;
                    }
                    String homeName = args[1];
                    boolean found = false;
                    for (int i = 0; i < homeList.func_74745_c(); ++i) {
                        NBTTagCompound tag = homeList.func_150305_b(i);
                        if (!tag.func_74779_i("Name").equals(homeName)) continue;
                        homeList.func_74744_a(i);
                        playerData.func_74782_a("HomeList", (NBTBase)homeList);
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.delete.success", Dateiverwaltung.standard, homeName);
                        found = true;
                        break;
                    }
                    if (!found) {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.delete.not_found", Dateiverwaltung.error, homeName);
                    }
                } else {
                    String homeName = subCommand;
                    for (int i = 0; i < homeList.func_74745_c(); ++i) {
                        NBTTagCompound tag = homeList.func_150305_b(i);
                        if (!tag.func_74779_i("Name").equals(homeName)) continue;
                        double x = tag.func_74769_h("X");
                        double y = tag.func_74769_h("Y");
                        double z = tag.func_74769_h("Z");
                        player.func_70634_a(x, y, z);
                        LangNetworkHandler.sendTranslationMessage(sender, "command.home.teleport.success", Dateiverwaltung.standard, homeName);
                        return;
                    }
                    LangNetworkHandler.sendTranslationMessage(sender, "command.home.not_found", Dateiverwaltung.error, homeName);
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.home.only_players", Dateiverwaltung.error, new Object[0]);
            }
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("set");
                completions.add("delete");
                EntityPlayerMP player = (EntityPlayerMP)sender;
                NBTTagList homeList = player.getEntityData().func_150295_c("HomeList", 10);
                for (int i = 0; i < homeList.func_74745_c(); ++i) {
                    NBTTagCompound tag = homeList.func_150305_b(i);
                    completions.add(tag.func_74779_i("Name"));
                }
                return CommandHandler.func_175762_a((String[])args, completions);
            }
            if (args.length == 2 && (args[0].equals("delete") || args[0].equals("set"))) {
                ArrayList<String> homeNames = new ArrayList<String>();
                EntityPlayerMP player = (EntityPlayerMP)sender;
                NBTTagList homeList = player.getEntityData().func_150295_c("HomeList", 10);
                for (int i = 0; i < homeList.func_74745_c(); ++i) {
                    NBTTagCompound tag = homeList.func_150305_b(i);
                    homeNames.add(tag.func_74779_i("Name"));
                }
                return CommandHandler.func_175762_a((String[])args, homeNames);
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }
    }
}

