/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandInv
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final File INVENTORY_SAVE_DIR = new File("config/minewache/mw-invsave/");

    public CommandInv(ElementsMinewacheRolePlayMod instance) {
        super(instance, 280);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private final String successColor = Dateiverwaltung.standard;
        private final String warningColor = Dateiverwaltung.warning;
        private final String errorColor = Dateiverwaltung.error;
        private final String standardColor = Dateiverwaltung.standard;

        public String func_71517_b() {
            return "inv";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/inv <save|load|delete> <name>";
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, this.func_71517_b());
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                completions.add("save");
                completions.add("load");
                completions.add("delete");
                return CommandHandler.func_175762_a((String[])args, completions);
            }
            if (args.length == 2 && ("load".equalsIgnoreCase(args[0]) || "delete".equalsIgnoreCase(args[0]))) {
                try {
                    EntityPlayerMP player = CommandHandler.func_71521_c((ICommandSender)sender);
                    UUID playerUUID = player.func_110124_au();
                    File[] files = INVENTORY_SAVE_DIR.listFiles((dir, name) -> name.startsWith(playerUUID.toString()) && name.endsWith(".dat"));
                    if (files != null) {
                        ArrayList<String> completions = new ArrayList<String>();
                        for (File file : files) {
                            String fileName = file.getName();
                            String invName = fileName.substring(playerUUID.toString().length() + 1, fileName.length() - 4);
                            completions.add(invName);
                        }
                        return CommandHandler.func_175762_a((String[])args, completions);
                    }
                }
                catch (CommandException commandException) {
                    // empty catch block
                }
            }
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] string, int index) {
            return false;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            EntityPlayerMP player;
            if (args.length < 2) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.inv.usage_error", this.standardColor, new Object[0]);
                return;
            }
            try {
                player = CommandHandler.func_71521_c((ICommandSender)sender);
            }
            catch (PlayerNotFoundException e) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.inv.player_not_found", this.errorColor, new Object[0]);
                return;
            }
            String action = args[0];
            String name = args[1];
            UUID playerUUID = player.func_110124_au();
            try {
                if ("save".equalsIgnoreCase(action)) {
                    this.saveInventory(player, name, playerUUID);
                    LangNetworkHandler.sendTranslationMessage(sender, "command.inv.save.success", this.successColor, name);
                } else if ("load".equalsIgnoreCase(action)) {
                    if (this.loadInventory(player, name, playerUUID)) {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.inv.load.success", this.standardColor, name);
                    } else {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.inv.load.not_found", this.errorColor, name);
                    }
                } else if ("delete".equalsIgnoreCase(action)) {
                    if (this.deleteInventory(name, playerUUID)) {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.inv.delete.success", this.standardColor, name);
                    } else {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.inv.delete.not_found", this.errorColor, name);
                    }
                } else {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.inv.invalid_action", this.errorColor, action);
                }
            }
            catch (IOException | NBTException e) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.inv.error", this.errorColor, e.getMessage());
            }
        }

        private void saveInventory(EntityPlayerMP player, String name, UUID playerUUID) throws IOException, CommandException {
            File file;
            if (!INVENTORY_SAVE_DIR.exists()) {
                INVENTORY_SAVE_DIR.mkdirs();
            }
            if ((file = new File(INVENTORY_SAVE_DIR, playerUUID.toString() + "_" + name + ".dat")).exists()) {
                throw new CommandException(Dateiverwaltung.error + new TextComponentTranslation("command.inv.save.exists", new Object[]{name}).func_150260_c(), new Object[0]);
            }
            NBTTagCompound inventoryNBT = new NBTTagCompound();
            inventoryNBT.func_74782_a("Inventory", (NBTBase)player.field_71071_by.func_70442_a(new NBTTagList()));
            try (FileOutputStream fos = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)inventoryNBT, (OutputStream)fos);
            }
        }

        private boolean loadInventory(EntityPlayerMP player, String name, UUID playerUUID) throws IOException, NBTException {
            NBTTagCompound inventoryNBT;
            File file = new File(INVENTORY_SAVE_DIR, playerUUID.toString() + "_" + name + ".dat");
            if (!file.exists()) {
                return false;
            }
            try (FileInputStream fis = new FileInputStream(file);){
                inventoryNBT = CompressedStreamTools.func_74796_a((InputStream)fis);
            }
            player.field_71071_by.func_70443_b(inventoryNBT.func_150295_c("Inventory", 10));
            return true;
        }

        private boolean deleteInventory(String name, UUID playerUUID) throws IOException {
            File file = new File(INVENTORY_SAVE_DIR, playerUUID.toString() + "_" + name + ".dat");
            if (!file.exists()) {
                return false;
            }
            return file.delete();
        }
    }
}

