/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.economy.EcoGlobal;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandMoney
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Logger LOGGER = Logger.getLogger(CommandMoney.class.getName());
    private static EcoGlobal economyManager;

    public CommandMoney(ElementsMinewacheRolePlayMod instance) {
        super(instance, 93);
        economyManager = new EcoGlobal(instance);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private static final String STANDARD_COLOR = Dateiverwaltung.standard;
        private static final String WARNING_COLOR = Dateiverwaltung.warning;
        private static final String ERROR_COLOR = Dateiverwaltung.error;
        private static final String SUCCESS_COLOR = Dateiverwaltung.sucess;
        private static final String PLAYERNAME_COLOR = Dateiverwaltung.playername;
        private static final String SENDERNAME_COLOR = Dateiverwaltung.sendername;

        public int compareTo(@Nonnull ICommand other) {
            return this.func_71517_b().compareTo(other.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender var1) {
            return true;
        }

        @Nonnull
        public List<String> func_71514_a() {
            return Collections.emptyList();
        }

        @Nonnull
        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return Collections.emptyList();
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "money";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/money [<arguments>]";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            try {
                if (!Dateiverwaltung.useMySQL.booleanValue()) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.money.mysql_not_connected", WARNING_COLOR, new Object[0]);
                    return;
                }
                if (!(sender instanceof EntityPlayer)) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.money.player_only", ERROR_COLOR, new Object[0]);
                    return;
                }
                EntityPlayer player = (EntityPlayer)sender;
                String playerName = player.func_70005_c_();
                LOGGER.fine("Processing money command for player: " + playerName);
                double balance = economyManager.getBalance(player);
                String formattedBalance = String.format("%.2f", balance);
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "command.money.balance", STANDARD_COLOR, SUCCESS_COLOR + formattedBalance);
                LOGGER.fine("Sent balance " + formattedBalance + " to player: " + playerName);
            }
            catch (Exception e) {
                LOGGER.severe("Error executing money command: " + e.getMessage());
                LangNetworkHandler.sendTranslationMessage(sender, "command.money.error", ERROR_COLOR, new Object[0]);
            }
        }
    }
}

