/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandProp
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandProp(ElementsMinewacheRolePlayMod instance) {
        super(instance, 285);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        public String func_71517_b() {
            return "prop";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/prop <string1> x1 c2 cx2 , <string2> x2 c5 cx3";
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            String[] propDefinitions;
            if (args.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid arguments! Usage: " + this.func_71518_a(sender)));
                return;
            }
            String fullCommand = String.join((CharSequence)" ", args);
            for (String propDefinition : propDefinitions = fullCommand.split("\\s*,\\s*")) {
                String[] propArgs = propDefinition.trim().split("\\s+");
                if (propArgs.length == 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid prop definition! Usage: " + this.func_71518_a(sender)));
                    continue;
                }
                String customName = propArgs[0];
                double doubleN1 = 0.0;
                double doubleN2 = 0.25;
                double doubleN3 = 0.0;
                double rotation = 0.0;
                int count = 1;
                double doubleN6 = 0.0;
                double doubleN7 = 0.0;
                double doubleN8 = 0.0;
                int nonPrefixedArgIndex = 1;
                for (int i = 1; i < propArgs.length; ++i) {
                    String arg = propArgs[i];
                    try {
                        if (arg.startsWith("~")) {
                            arg = this.parseCoordinate(arg);
                        }
                        if (arg.startsWith("x")) {
                            doubleN1 = Double.parseDouble(arg.substring(1));
                            continue;
                        }
                        if (arg.startsWith("y")) {
                            doubleN2 = 0.25 + Double.parseDouble(arg.substring(1));
                            continue;
                        }
                        if (arg.startsWith("z")) {
                            doubleN3 = Double.parseDouble(arg.substring(1));
                            continue;
                        }
                        if (arg.startsWith("r")) {
                            rotation = Double.parseDouble(arg.substring(1));
                            continue;
                        }
                        if (arg.startsWith("c") && !arg.startsWith("cx") && !arg.startsWith("cy") && !arg.startsWith("cz")) {
                            count = Integer.parseInt(arg.substring(1));
                            continue;
                        }
                        if (arg.startsWith("ox")) {
                            doubleN6 = Double.parseDouble(arg.substring(2));
                            continue;
                        }
                        if (arg.startsWith("oy")) {
                            doubleN7 = Double.parseDouble(arg.substring(2));
                            continue;
                        }
                        if (arg.startsWith("oz")) {
                            doubleN8 = Double.parseDouble(arg.substring(2));
                            continue;
                        }
                        switch (nonPrefixedArgIndex) {
                            case 1: {
                                doubleN1 = Double.parseDouble(arg);
                                break;
                            }
                            case 2: {
                                doubleN2 = 0.25 + Double.parseDouble(arg);
                                break;
                            }
                            case 3: {
                                doubleN3 = Double.parseDouble(arg);
                                break;
                            }
                            case 4: {
                                rotation = Double.parseDouble(arg);
                                break;
                            }
                            case 5: {
                                count = Integer.parseInt(arg);
                                break;
                            }
                            case 6: {
                                doubleN6 = Double.parseDouble(arg);
                                break;
                            }
                            case 7: {
                                doubleN7 = Double.parseDouble(arg);
                                break;
                            }
                            case 8: {
                                doubleN8 = Double.parseDouble(arg);
                                break;
                            }
                            default: {
                                sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid argument: " + arg));
                                return;
                            }
                        }
                        ++nonPrefixedArgIndex;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Invalid number format in argument: " + arg));
                        return;
                    }
                }
                File configFile = new File("config/minewache/mw-config/mw-props.cfg");
                try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                    String line;
                    ArrayList<String> matchingProps = new ArrayList<String>();
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split("=");
                        if (parts.length != 2 || !parts[0].trim().toLowerCase().startsWith(customName.toLowerCase())) continue;
                        matchingProps.add(parts[0].trim());
                    }
                    if (matchingProps.isEmpty()) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "No Prop found matching '" + customName + "'."));
                        continue;
                    }
                    String propName = (String)matchingProps.get(0);
                    String entityName = this.getEntityNameForProperty(propName, configFile);
                    String summonCommand = String.format("summon dynamxmod:entity_prop ~%f ~%f ~%f {vehicleName:\"%s\",Rotation:[%sf]}", doubleN1, doubleN2, doubleN3, entityName, rotation);
                    for (int j = 0; j < count; ++j) {
                        server.func_71187_D().func_71556_a(sender, summonCommand);
                        summonCommand = String.format("summon dynamxmod:entity_prop ~%f ~%f ~%f {vehicleName:\"%s\",Rotation:[%sf]}", doubleN1 += doubleN6, doubleN2 += doubleN7, doubleN3 += doubleN8, entityName, rotation);
                    }
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Error reading configuration file: " + e.getMessage()));
                }
            }
        }

        private String parseCoordinate(String arg) {
            return arg.equals("~") ? "0" : arg.substring(1);
        }

        private String getEntityNameForProperty(String propName, File configFile) throws IOException {
            try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split("=");
                    if (parts.length != 2 || !parts[0].trim().equalsIgnoreCase(propName)) continue;
                    String string = parts[1].trim();
                    return string;
                }
            }
            throw new IOException(Dateiverwaltung.warning + "Property '" + propName + "' not found in configuration file.");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
            if (args.length == 1) {
                ArrayList<String> completions = new ArrayList<String>();
                File configFile = new File("config/minewache/mw-config/mw-props.cfg");
                try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        String[] parts = line.split("=");
                        if (parts.length != 2) continue;
                        completions.add(parts[0].trim());
                    }
                }
                catch (IOException e) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(Dateiverwaltung.warning + "Error reading configuration file: " + e.getMessage()));
                }
                return CommandHandler.func_175762_a((String[])args, completions);
            }
            return super.func_184883_a(server, sender, args, targetPos);
        }

        public boolean func_82358_a(String[] args, int index) {
            return false;
        }
    }
}

