/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import com.mojang.authlib.GameProfile;
import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.item.ItemAusweis;
import de.sarocesch.minewacheroleplaymod.item.ItemAusweisw;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import de.sarocesch.minewacheroleplaymod.util.FeatureFlags;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandRegisterid
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandRegisterid(ElementsMinewacheRolePlayMod instance) {
        super(instance, 282);
    }

    public static void insertPlayerData(EntityPlayer player, String playerName, String name, String lastName, String date, String height, String sex) {
        if (!FeatureFlags.MYSQL_ENABLED) {
            System.err.println("Warning: MySQL driver not present; ID not stored.");
            return;
        }
        if (!Dateiverwaltung.useMySQL.booleanValue()) {
            System.err.println("Warning: MySQL is not activated, ID card not stored in MySQL.");
            return;
        }
        String url = "jdbc:mysql://" + Dateiverwaltung.host + ":3306/" + Dateiverwaltung.databaseName + "?useSSL=false&verifyServerCertificate=false";
        String user = Dateiverwaltung.username;
        String password = Dateiverwaltung.password;
        double newHeight = CommandRegisterid.stringToDouble(height);
        try (Connection connection = DriverManager.getConnection(url, user, password);
             Statement statement = connection.createStatement();){
            String worldName = CommandRegisterid.getWorldName((EntityPlayerMP)player);
            ResultSet existingPlayerResult = statement.executeQuery("SELECT id FROM ausweis WHERE uuid = '" + playerName + "' AND world = '" + worldName + "'");
            if (existingPlayerResult.next()) {
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "command.registerid.already_registered", Dateiverwaltung.warning, new Object[0]);
                return;
            }
            ResultSet maxIdResult = statement.executeQuery("SELECT MAX(id) AS max_id FROM ausweis");
            int nextID = 1;
            if (maxIdResult.next()) {
                nextID = maxIdResult.getInt("max_id") + 1;
            }
            String[] parts = date.split("\\.");
            String newDate = parts[2] + "-" + parts[1] + "-" + parts[0];
            String insertDataQuery = "INSERT INTO ausweis (id, uuid, name, lastname, date, size, sex, world) VALUES (" + nextID + ", '" + playerName + "', '" + name + "', '" + lastName + "', '" + newDate + "', '" + newHeight + "', '" + sex + "', '" + worldName + "')";
            int result = statement.executeUpdate(insertDataQuery);
            if (result >= 0) {
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "command.registerid.success", Dateiverwaltung.standard, new Object[0]);
                CommandRegisterid.giveAusweis(player, name, lastName, date, height, sex, playerName);
            } else {
                LangNetworkHandler.sendTranslationMessage((ICommandSender)player, "command.registerid.register_error", Dateiverwaltung.warning, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void giveAusweis(EntityPlayer player, String name, String lastName, String date, String height, String sex, String playerName) {
        ItemStack ausweis = new ItemStack(sex.equals("w") ? ItemAusweisw.block : ItemAusweis.block);
        NBTTagCompound nbt = new NBTTagCompound();
        List<String> lore = Arrays.asList(name, lastName, date, height, sex, playerName);
        nbt.func_74778_a("AusweisData", String.join((CharSequence)",", lore));
        ausweis.func_77982_d(nbt);
        if (!player.func_191521_c(ausweis)) {
            player.func_71019_a(ausweis, false);
        }
    }

    public static double stringToDouble(String height) {
        height = height.replace(",", ".");
        try {
            return Double.parseDouble(height);
        }
        catch (NumberFormatException e) {
            System.out.println("Error parsing height to double: " + e.getMessage());
            return 0.0;
        }
    }

    private static String getWorldName(EntityPlayerMP player) {
        return player.func_71121_q().func_72860_G().func_75765_b().getName();
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private static boolean isAlpha(String str) {
            return Pattern.matches("[a-zA-Z]+", str);
        }

        public String func_71517_b() {
            return "registerid";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/registerid <Firstname> <Lastname> <Date> <Height> <Sex>";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) throws CommandException {
            if (!Dateiverwaltung.useMySQL.booleanValue()) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.registerid.mysql_not_connected", Dateiverwaltung.warning, new Object[0]);
                return;
            }
            if (cmd.length == 5 && sender instanceof EntityPlayerMP) {
                String sex;
                String name = cmd.length >= 1 && CommandHandler.isAlpha(cmd[0]) ? cmd[0] : null;
                String lastName = cmd.length >= 2 && CommandHandler.isAlpha(cmd[1]) ? cmd[1] : null;
                String date = cmd.length >= 3 ? cmd[2] : null;
                String height = cmd.length >= 4 ? cmd[3] : null;
                String string = sex = cmd.length >= 5 && CommandHandler.isAlpha(cmd[4]) ? cmd[4] : null;
                if (name == null || lastName == null || date == null || height == null || sex == null) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.registerid.syntax_error", Dateiverwaltung.warning, new Object[0]);
                    return;
                }
                EntityPlayerMP player = (EntityPlayerMP)sender;
                try {
                    GameProfile gameProfile = player.func_146103_bH();
                    if (gameProfile != null) {
                        UUID playerUUID = gameProfile.getId();
                        CommandRegisterid.insertPlayerData((EntityPlayer)player, playerUUID.toString(), name, lastName, date, height, sex);
                    } else {
                        LangNetworkHandler.sendTranslationMessage(sender, "command.registerid.profile_error", Dateiverwaltung.warning, new Object[0]);
                    }
                    player.func_71053_j();
                }
                catch (Exception e) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.registerid.processing_error", Dateiverwaltung.warning, new Object[0]);
                    e.printStackTrace();
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.registerid.syntax_error", Dateiverwaltung.warning, new Object[0]);
            }
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return Collections.singletonList("Firstname");
            }
            if (args.length == 2) {
                return Collections.singletonList("Lastname");
            }
            if (args.length == 3) {
                return Arrays.asList("Date", "01.01.2000", "05.05.1995");
            }
            if (args.length == 4) {
                return Arrays.asList("Height", "1.80", "1.75");
            }
            if (args.length == 5) {
                return Arrays.asList("m", "w");
            }
            return Collections.emptyList();
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }
    }
}

