/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandRemoveLore
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandRemoveLore(ElementsMinewacheRolePlayMod instance) {
        super(instance, 278);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private final String standardFarbe = Dateiverwaltung.standard;
        private final String warningFarbe = Dateiverwaltung.warning;
        private final String errorFarbe = Dateiverwaltung.error;

        public String func_71517_b() {
            return "removelore";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.removelore.usage", new Object[0]).func_150260_c();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length < 1) {
                LangNetworkHandler.sendTranslationMessage(sender, "message.removelore.usage", Dateiverwaltung.warning, new Object[0]);
                return;
            }
            if (sender instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)sender;
                ItemStack heldItem = player.func_184614_ca();
                if (!heldItem.func_190926_b()) {
                    ArrayList<String> lore = new ArrayList<String>();
                    if (heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("display")) {
                        NBTTagList loreTag = heldItem.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
                        for (int i = 0; i < loreTag.func_74745_c(); ++i) {
                            lore.add(loreTag.func_150307_f(i));
                        }
                    }
                    if (lore.contains(args[0])) {
                        lore.remove(args[0]);
                        NBTTagList newLoreTag = new NBTTagList();
                        for (String line : lore) {
                            newLoreTag.func_74742_a((NBTBase)new NBTTagString(line));
                        }
                        if (!heldItem.func_77942_o()) {
                            heldItem.func_77982_d(new NBTTagCompound());
                        }
                        if (!heldItem.func_77978_p().func_74764_b("display")) {
                            heldItem.func_77978_p().func_74782_a("display", (NBTBase)new NBTTagCompound());
                        }
                        heldItem.func_77978_p().func_74775_l("display").func_74782_a("Lore", (NBTBase)newLoreTag);
                        LangNetworkHandler.sendTranslationMessage(sender, "message.removelore.success", Dateiverwaltung.standard, new Object[0]);
                    } else {
                        LangNetworkHandler.sendTranslationMessage(sender, "message.removelore.not_found", Dateiverwaltung.error, new Object[0]);
                    }
                } else {
                    LangNetworkHandler.sendTranslationMessage(sender, "message.removelore.no_item", Dateiverwaltung.error, new Object[0]);
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "message.removelore.not_player", Dateiverwaltung.error, new Object[0]);
            }
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, "minewache.command.removelore");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return CommandHandler.func_175762_a((String[])args, this.getLoreLines(sender));
            }
            return Collections.emptyList();
        }

        private List<String> getLoreLines(ICommandSender sender) {
            EntityPlayer player;
            ItemStack heldItem;
            ArrayList<String> loreLines = new ArrayList<String>();
            if (sender instanceof EntityPlayer && !(heldItem = (player = (EntityPlayer)sender).func_184614_ca()).func_190926_b() && heldItem.func_77942_o() && heldItem.func_77978_p().func_74764_b("display")) {
                NBTTagList loreTag = heldItem.func_77978_p().func_74775_l("display").func_150295_c("Lore", 8);
                for (int i = 0; i < loreTag.func_74745_c(); ++i) {
                    loreLines.add(loreTag.func_150307_f(i));
                }
            }
            return loreLines;
        }
    }
}

