/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandSetspawn
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandSetspawn(ElementsMinewacheRolePlayMod instance) {
        super(instance, 279);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        private final String standardFarbe = Dateiverwaltung.standard;
        private final String warningFarbe = Dateiverwaltung.warning;
        private final String errorFarbe = Dateiverwaltung.error;
        private final String successFarbe = Dateiverwaltung.sucess;

        public String func_71517_b() {
            return "setspawn";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/setspawn";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                BlockPos spawnPos = player.func_180425_c();
                float yaw = player.field_70177_z;
                float pitch = player.field_70125_A;
                LangNetworkHandler.sendTranslationMessage(sender, "command.setspawn.success", this.successFarbe, spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), Float.valueOf(yaw), Float.valueOf(pitch));
                this.saveSpawnData(spawnPos, yaw, pitch, sender);
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, "command.setspawn.player_only", this.errorFarbe, new Object[0]);
            }
        }

        private void saveSpawnData(BlockPos spawnPos, float yaw, float pitch, ICommandSender sender) {
            try {
                File worldFolder = sender.func_130014_f_().func_72860_G().func_75765_b();
                File minewachemodFolder = new File(worldFolder, "Minewachemod");
                if (!minewachemodFolder.exists()) {
                    minewachemodFolder.mkdirs();
                }
                File dataFile = new File(minewachemodFolder, "spawn.spawninfo");
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(dataFile));){
                    writer.write(String.format("Spawn Coordinates:%nX: %d%nY: %d%nZ: %d%nYaw: %.2f%nPitch: %.2f", spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p(), Float.valueOf(yaw), Float.valueOf(pitch)));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

