/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandTimespeed
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandTimespeed(ElementsMinewacheRolePlayMod instance) {
        super(instance, 290);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
        private static long speed = 0L;

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return sender.func_70003_b(2, this.func_71517_b());
        }

        public List<String> func_71514_a() {
            return Collections.singletonList("timespeed");
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            return new ArrayList<String>();
        }

        public boolean func_82358_a(String[] args, int index) {
            return false;
        }

        public String func_71517_b() {
            return "timespeed";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.timespeed.usage", new Object[0]).func_150254_d();
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (args.length != 1) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.timespeed.invalid_arguments", Dateiverwaltung.warning, new Object[0]);
                return;
            }
            String timeStr = args[0];
            long time = this.parseTime(timeStr);
            if (time <= 0L) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.timespeed.invalid_time_format", Dateiverwaltung.warning, new Object[0]);
                return;
            }
            speed = time;
            LangNetworkHandler.sendTranslationMessage(sender, "command.timespeed.success", Dateiverwaltung.standard, timeStr);
            scheduler.shutdownNow();
            scheduler.scheduleAtFixedRate(() -> {
                try {
                    WorldServer world = server.func_71218_a(0);
                    long worldTime = world.func_72820_D();
                    long newTime = (worldTime + 24000L / speed) % 24000L;
                    world.func_72877_b(newTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }, 0L, 50L, TimeUnit.MILLISECONDS);
        }

        private long parseTime(String timeStr) {
            try {
                if (timeStr.endsWith("s")) {
                    return Long.parseLong(timeStr.replace("s", "")) * 1000L;
                }
                if (timeStr.endsWith("m")) {
                    return Long.parseLong(timeStr.replace("m", "")) * 1000L * 60L;
                }
                if (timeStr.endsWith("h")) {
                    return Long.parseLong(timeStr.replace("h", "")) * 1000L * 60L * 60L;
                }
                return -1L;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
    }
}

