/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandVanish
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandVanish(ElementsMinewacheRolePlayMod instance) {
        super(instance, 330);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    extends CommandBase {
        public String func_71517_b() {
            return "vanish";
        }

        public String func_71518_a(ICommandSender sender) {
            return new TextComponentTranslation("command.vanish.usage", new Object[0]).func_150254_d();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                return this.getListOfPlayerUsernames(server, args[0]);
            }
            return Collections.emptyList();
        }

        private List<String> getListOfPlayerUsernames(MinecraftServer server, String input) {
            ArrayList<String> matches = new ArrayList<String>();
            Collections.addAll(matches, server.func_184103_al().func_72369_d());
            return matches;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            if (sender instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)sender;
                NBTTagCompound playerData = player.getEntityData();
                boolean vanished = playerData.func_74767_n("vanished");
                if (args.length > 0 && !args[0].isEmpty()) {
                    String playerName = args[0];
                    this.executeSpecialFunctionForPlayer(server, sender, playerName, playerData);
                } else {
                    vanished = !vanished;
                    playerData.func_74757_a("vanished", vanished);
                    if (vanished) {
                        server.func_71187_D().func_71556_a((ICommandSender)server, "cpm setskin -f " + player.func_70005_c_() + " UwsBAQMKAAEBAAgCCQEAAAAAADA=");
                        LangNetworkHandler.sendTranslationMessage(sender, "command.vanish.now_invisible", Dateiverwaltung.standard, new Object[0]);
                    } else {
                        server.func_71187_D().func_71556_a((ICommandSender)server, "cpm setskin -r " + player.func_70005_c_());
                        LangNetworkHandler.sendTranslationMessage(sender, "command.vanish.now_visible", Dateiverwaltung.warning, new Object[0]);
                    }
                }
            }
        }

        private void executeSpecialFunctionForPlayer(MinecraftServer server, ICommandSender sender, String playerName, NBTTagCompound playerData) {
            boolean vanished = !playerData.func_74767_n("vanished");
            playerData.func_74757_a("vanished", vanished);
            if (vanished) {
                LangNetworkHandler.sendTranslationMessage(sender, "command.vanish.success_for_player", Dateiverwaltung.standard, playerName);
            } else {
                server.func_71187_D().func_71556_a((ICommandSender)server, "cpm setskin -r " + playerName);
                LangNetworkHandler.sendTranslationMessage(sender, "command.vanish.reset_for_player", Dateiverwaltung.warning, playerName);
            }
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }
    }
}

