/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.command;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.network.LangNetworkHandler;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class CommandWarp
extends ElementsMinewacheRolePlayMod.ModElement {
    public CommandWarp(ElementsMinewacheRolePlayMod instance) {
        super(instance, 254);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    public static class CommandHandler
    implements ICommand {
        String standardFarbe = Dateiverwaltung.standard;
        String warningFarbe = Dateiverwaltung.warning;
        String sucessFarbe = Dateiverwaltung.sucess;
        String warpnameFarbe = Dateiverwaltung.warpname;
        String playernameFarbe = Dateiverwaltung.playername;
        String sendernameFarbe = Dateiverwaltung.sendername;
        String errorFarbe = Dateiverwaltung.error;

        public int compareTo(ICommand c) {
            return this.func_71517_b().compareTo(c.func_71517_b());
        }

        public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
            return true;
        }

        public List<String> func_71514_a() {
            return new ArrayList<String>();
        }

        public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
            if (args.length == 1) {
                ArrayList<String> warpNames = new ArrayList<String>();
                try {
                    String line;
                    String fileName = server.func_71218_a(0).func_72860_G().func_75765_b().getPath() + "/Minewachemod/WARPS.warpinfo";
                    BufferedReader reader = new BufferedReader(new FileReader(fileName));
                    while ((line = reader.readLine()) != null) {
                        String warpName;
                        if (!line.contains("{") || !(warpName = line.substring(0, line.indexOf("{")).trim()).startsWith(args[0])) continue;
                        warpNames.add(warpName);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return warpNames;
            }
            if (args.length == 2) {
                ArrayList<String> playerNames = new ArrayList<String>();
                for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                    if (!player.func_70005_c_().startsWith(args[1])) continue;
                    playerNames.add(player.func_70005_c_());
                }
                return playerNames;
            }
            return null;
        }

        public boolean func_82358_a(String[] string, int index) {
            return true;
        }

        public String func_71517_b() {
            return "warp";
        }

        public String func_71518_a(ICommandSender var1) {
            return "/warp <warpname> [<playername>]";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] cmd) {
            if (cmd.length >= 1 && cmd.length <= 2) {
                String warpName = cmd[0];
                try {
                    String line;
                    String fileName = server.func_71218_a(0).func_72860_G().func_75765_b().getPath() + "/Minewachemod/WARPS.warpinfo";
                    BufferedReader reader = new BufferedReader(new FileReader(fileName));
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith(warpName)) continue;
                        double[] warpInfo = new double[5];
                        for (int i = 0; i < 5; ++i) {
                            String infoLine = reader.readLine().trim();
                            warpInfo[i] = Double.parseDouble(infoLine);
                        }
                        if (cmd.length == 2 && !sender.func_70003_b(2, this.func_71517_b())) {
                            LangNetworkHandler.sendTranslationMessage(sender, "command.warp.no_permission", this.warningFarbe, new Object[0]);
                            reader.close();
                            return;
                        }
                        if (cmd.length == 2) {
                            String playerName = cmd[1];
                            EntityPlayerMP targetPlayer = server.func_184103_al().func_152612_a(playerName);
                            if (targetPlayer != null) {
                                targetPlayer.field_71135_a.func_147364_a(warpInfo[0], warpInfo[1], warpInfo[2], (float)warpInfo[4], (float)warpInfo[3]);
                                LangNetworkHandler.sendTranslationMessage((ICommandSender)targetPlayer, "command.warp.teleport_success", this.standardFarbe, warpName);
                                LangNetworkHandler.sendTranslationMessage(sender, "command.warp.teleport_other_success", this.standardFarbe, playerName, warpName);
                            } else {
                                LangNetworkHandler.sendTranslationMessage(sender, "command.warp.player_not_found", this.warningFarbe, playerName);
                            }
                        } else {
                            EntityPlayerMP playerMP = (EntityPlayerMP)sender.func_174793_f();
                            playerMP.field_71135_a.func_147364_a(warpInfo[0], warpInfo[1], warpInfo[2], (float)warpInfo[4], (float)warpInfo[3]);
                            LangNetworkHandler.sendTranslationMessage((ICommandSender)playerMP, "command.warp.teleport_success", this.standardFarbe, warpName);
                        }
                        reader.close();
                        return;
                    }
                    reader.close();
                    LangNetworkHandler.sendTranslationMessage(sender, "command.warp.not_found", this.warningFarbe, warpName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LangNetworkHandler.sendTranslationMessage(sender, "command.warp.error_reading", this.errorFarbe, new Object[0]);
                }
                catch (NumberFormatException e) {
                    LangNetworkHandler.sendTranslationMessage(sender, "command.warp.error_format", this.errorFarbe, new Object[0]);
                }
            } else {
                LangNetworkHandler.sendTranslationMessage(sender, this.func_71518_a(sender), this.standardFarbe, new Object[0]);
            }
        }
    }
}

