/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.database;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class MySQLCreate
extends ElementsMinewacheRolePlayMod.ModElement {
    private static final Logger LOGGER = Logger.getLogger(MySQLCreate.class.getName());

    public MySQLCreate(ElementsMinewacheRolePlayMod instance) {
        super(instance, 76);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.initializeDatabase();
    }

    private void initializeDatabase() {
        if (!Dateiverwaltung.useMySQL.booleanValue()) {
            LOGGER.info("MySQL is disabled. Database-dependent features will not be available.");
            return;
        }
        LOGGER.info("Initializing MySQL database...");
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                LOGGER.severe("Failed to establish database connection");
                return;
            }
            this.createTable(connection, "ausweis", "id INT PRIMARY KEY, uuid VARCHAR(355), name VARCHAR(255), lastname VARCHAR(255), date VARCHAR(255), size VARCHAR(255), sex VARCHAR(10), world VARCHAR(255)");
            this.createTable(connection, "economy", "id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(255), money DOUBLE DEFAULT 0.0, world VARCHAR(255)");
            this.createTable(connection, "garage", "id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(255), VehicleName VARCHAR(255), VehicleId VARCHAR(255), VehicleData VARCHAR(10000), world VARCHAR(255), ausgeparkt BOOLEAN DEFAULT FALSE, x INT, y INT, z INT, VehicleType VARCHAR(255)");
            this.createTable(connection, "polizei", "id INT PRIMARY KEY, uuid VARCHAR(255), description VARCHAR(2000), note VARCHAR(2000), cords VARCHAR(255), officer VARCHAR(2000), crime VARCHAR(2000), zivi VARCHAR(2000), active BOOLEAN DEFAULT TRUE");
            this.createTable(connection, "ema", "id INT AUTO_INCREMENT PRIMARY KEY, uuid VARCHAR(255), anschrifft VARCHAR(255), immobilien VARCHAR(2000)");
            LOGGER.info("Database initialization completed successfully");
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Database initialization failed", e);
        }
    }

    private Connection createConnection() throws SQLException {
        String url = "jdbc:mysql://" + Dateiverwaltung.host + ":3306/" + Dateiverwaltung.databaseName + "?useSSL=false&verifyServerCertificate=false&autoReconnect=true";
        return DriverManager.getConnection(url, Dateiverwaltung.username, Dateiverwaltung.password);
    }

    private void createTable(@Nonnull Connection connection, @Nonnull String tableName, @Nonnull String tableColumns) {
        try (Statement statement = connection.createStatement();){
            boolean tableExists = false;
            try (ResultSet tables = connection.getMetaData().getTables(null, null, tableName, null);){
                tableExists = tables.next();
            }
            if (tableExists) {
                LOGGER.fine("Table '" + tableName + "' already exists, checking for missing columns...");
                this.updateTableStructure(connection, statement, tableName, tableColumns);
            } else {
                LOGGER.info("Creating table '" + tableName + "'...");
                this.createNewTable(statement, tableName, tableColumns);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error managing table '" + tableName + "'", e);
        }
    }

    private void updateTableStructure(Connection connection, Statement statement, String tableName, String tableColumns) throws SQLException {
        String[] desiredColumns;
        ArrayList<String> existingColumns = new ArrayList<String>();
        String[] stringArray = null;
        try (ResultSet columns = connection.getMetaData().getColumns(null, null, tableName, null);){
            while (columns.next()) {
                existingColumns.add(columns.getString("COLUMN_NAME").toLowerCase());
            }
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        for (String column : desiredColumns = tableColumns.split(",\\s*")) {
            String columnName = column.trim().split("\\s+")[0].toLowerCase();
            if (existingColumns.contains(columnName)) continue;
            try {
                statement.execute("ALTER TABLE " + tableName + " ADD COLUMN " + column.trim());
                LOGGER.info("Added column '" + columnName + "' to table '" + tableName + "'");
            }
            catch (SQLException e) {
                LOGGER.warning("Failed to add column '" + columnName + "' to table '" + tableName + "': " + e.getMessage());
            }
        }
    }

    private void createNewTable(Statement statement, String tableName, String tableColumns) throws SQLException {
        String createTableQuery = "CREATE TABLE " + tableName + " (" + tableColumns + ")";
        statement.executeUpdate(createTableQuery);
        LOGGER.info("Table '" + tableName + "' created successfully!");
    }

    @Override
    public void initElements() {
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void generateWorld(Random random, int posX, int posZ, World world, int dimID, IChunkGenerator cg, IChunkProvider cp) {
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
    }
}

