/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.economy;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import de.sarocesch.minewacheroleplaymod.economy.EcoGlobal;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class PayCheck
extends ElementsMinewacheRolePlayMod.ModElement {
    static EcoGlobal pay;
    private int tickCounter = 0;
    private final ArrayList<String> rankNames = new ArrayList();

    public PayCheck(ElementsMinewacheRolePlayMod instance) {
        super(instance, 125);
        pay = new EcoGlobal(instance);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (Dateiverwaltung.useMySQL.booleanValue() && event.phase == TickEvent.Phase.START) {
            ++this.tickCounter;
            if (this.tickCounter >= Dateiverwaltung.payCheckInterval && Dateiverwaltung.enablePayCheck.booleanValue()) {
                if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                    double payCheckCount = Dateiverwaltung.payCheckCount;
                    for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                        String playerName = player.func_70005_c_();
                        boolean hasJob = false;
                        double playerSalary = 0.0;
                        for (String tag : player.func_184216_O()) {
                            if (!tag.startsWith("Job_")) continue;
                            hasJob = true;
                            break;
                        }
                        if (hasJob) {
                            String jobName = "";
                            String rankName = "";
                            for (String tag : player.func_184216_O()) {
                                if (!tag.startsWith("Job_")) continue;
                                String[] parts = tag.split("_");
                                jobName = parts[1];
                                rankName = parts[2];
                                break;
                            }
                            playerSalary = this.getRankSalary(jobName, rankName);
                            String message = Dateiverwaltung.standard + "Du hast Gehalt in H\ufffdhe von " + Dateiverwaltung.sucess + playerSalary + "\ufffd " + Dateiverwaltung.standard + "erhalten";
                            player.func_145747_a((ITextComponent)new TextComponentString(message));
                            pay.addBalance((EntityPlayer)player, playerSalary);
                            continue;
                        }
                        String message = Dateiverwaltung.standard + "Du hast Arbeitslosengeld in H\ufffdhe von " + Dateiverwaltung.sucess + payCheckCount + "\ufffd" + Dateiverwaltung.standard + "erhalten";
                        player.func_145747_a((ITextComponent)new TextComponentString(message));
                        pay.addBalance((EntityPlayer)player, payCheckCount);
                    }
                }
                this.tickCounter = 0;
            }
        }
    }

    private double getRankSalary(String jobName, String rankName) {
        File rankDir = new File("config/minewache/mw-ranks/ranks");
        File jobFile = new File(rankDir, jobName + ".txt");
        try {
            if (jobFile.exists()) {
                String line;
                BufferedReader reader = new BufferedReader(new FileReader(jobFile));
                while ((line = reader.readLine()) != null) {
                    String[] parts = line.split(";");
                    if (parts.length < 2 || !parts[0].equals(rankName)) continue;
                    reader.close();
                    return Double.parseDouble(parts[1]);
                }
                reader.close();
            }
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
        }
        return 0.0;
    }
}

