/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.builder;

import com.google.gson.Gson;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiDef;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiStorage;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.GuiElementDef;
import de.sarocesch.minewacheroleplaymod.gui.builder.texture.TextureCache;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.PacketExecuteGuiAction;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCustomDisplay
extends GuiScreen {
    private final String guiName;
    @Nullable
    private CustomGuiDef def;
    private static final int CELL_SIZE = 18;
    private static final int GRID_PADDING = 8;
    private int gridLeft;
    private int gridTop;
    private int gridWidth;
    private int gridHeight;

    public GuiCustomDisplay(String guiName) {
        this.guiName = guiName;
    }

    public void loadFromJson(String json) {
        try {
            Gson g = new Gson();
            this.def = (CustomGuiDef)g.fromJson(json, CustomGuiDef.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        if (this.def == null) {
            try {
                this.def = CustomGuiStorage.load(this.guiName);
            }
            catch (IOException e) {
                this.def = null;
            }
        }
        int cols = this.def != null ? this.def.cols : 9;
        int rows = this.def != null ? this.def.rows : 6;
        this.gridWidth = cols * 18 + 16;
        this.gridHeight = rows * 18 + 16;
        this.gridLeft = (this.field_146294_l - this.gridWidth) / 2;
        this.gridTop = (this.field_146295_m - this.gridHeight) / 2 + 10;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        String title = TextFormatting.BOLD + "GUI: " + this.guiName;
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, this.gridTop - 20, 0xFFFFFF);
        GuiCustomDisplay.func_73734_a((int)this.gridLeft, (int)this.gridTop, (int)(this.gridLeft + this.gridWidth), (int)(this.gridTop + this.gridHeight), (int)-1442840576);
        if (this.def != null) {
            for (GuiElementDef e : this.def.elements) {
                ResourceLocation rl;
                int x = this.gridLeft + 8 + e.col * 18;
                int y = this.gridTop + 8 + e.row * 18;
                if (e.texturePath != null && !e.texturePath.isEmpty() && (rl = TextureCache.get(e.texturePath)) != null) {
                    float prevZ = this.field_73735_i;
                    this.field_73735_i = -90.0f;
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_146297_k.func_110434_K().func_110577_a(rl);
                    GuiCustomDisplay.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179084_k();
                    this.field_73735_i = prevZ;
                }
                GuiCustomDisplay.func_73734_a((int)x, (int)y, (int)(x + 18 - 2), (int)(y + 18 - 2), (int)0x55FFFFFF);
            }
        } else {
            this.func_73732_a(this.field_146289_q, TextFormatting.RED + "Not found or failed to load", this.field_146294_l / 2, this.gridTop + this.gridHeight + 6, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.def == null) {
            return;
        }
        int cols = this.def.cols;
        int rows = this.def.rows;
        int cellX = mouseX - (this.gridLeft + 8);
        int cellY = mouseY - (this.gridTop + 8);
        if (cellX < 0 || cellY < 0) {
            return;
        }
        int col = cellX / 18;
        int row = cellY / 18;
        if (col < 0 || row < 0 || col >= cols || row >= rows) {
            return;
        }
        for (GuiElementDef e : this.def.elements) {
            if (e.col != col || e.row != row) continue;
            String cmd = null;
            boolean asPlayer = false;
            if (mouseButton == 0) {
                cmd = e.leftClickCommand;
                asPlayer = e.leftExecuteAsPlayer;
            } else if (mouseButton == 1) {
                cmd = e.rightClickCommand;
                asPlayer = e.rightExecuteAsPlayer;
            } else if (mouseButton == 2) {
                cmd = e.middleClickCommand;
                asPlayer = e.middleExecuteAsPlayer;
            }
            if (cmd == null || cmd.isEmpty()) break;
            String replaced = cmd.replace("{Player}", this.field_146297_k.field_71439_g != null ? this.field_146297_k.field_71439_g.func_70005_c_() : "");
            NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketExecuteGuiAction(replaced, asPlayer));
            break;
        }
    }

    public boolean func_73868_f() {
        return false;
    }
}

