/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.builder;

import com.google.gson.Gson;
import de.sarocesch.minewacheroleplaymod.gui.addons.GuiModernButton;
import de.sarocesch.minewacheroleplaymod.gui.builder.GuiSlotEditorOverlay;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiDef;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.GuiElementDef;
import de.sarocesch.minewacheroleplaymod.gui.builder.texture.TextureCache;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.PacketSaveCustomGui;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiCustomGuiBuilder
extends GuiScreen {
    private String guiName;
    private static final int GRID_COLS = 9;
    private static final int GRID_ROWS = 6;
    private static final int CELL_SIZE = 18;
    private static final int GRID_PADDING = 8;
    private int gridLeft;
    private int gridTop;
    private int gridWidth;
    private int gridHeight;
    private int nameFieldX;
    private int nameFieldY;
    private GuiTextField nameField;
    private GuiModernButton btnSave;
    private GuiModernButton btnCancel;
    private GuiModernButton btnAddSlot;
    private GuiModernButton btnRemoveSlot;
    private boolean removeMode = false;
    private final List<SlotElement> elements = new ArrayList<SlotElement>();
    @Nullable
    private SlotElement selected;
    private boolean addMode = false;
    @Nullable
    private CustomGuiDef preloaded;

    public GuiCustomGuiBuilder(String guiName) {
        this.guiName = guiName;
    }

    public void loadFromJson(String json) {
        try {
            Gson g = new Gson();
            this.preloaded = (CustomGuiDef)g.fromJson(json, CustomGuiDef.class);
            if (this.preloaded != null) {
                this.guiName = this.preloaded.name != null ? this.preloaded.name : this.guiName;
                this.elements.clear();
                for (GuiElementDef e : this.preloaded.elements) {
                    SlotElement se = new SlotElement(e.col, e.row);
                    se.leftAction = e.leftClickCommand;
                    se.rightAction = e.rightClickCommand;
                    se.middleAction = e.middleClickCommand;
                    se.texturePath = e.texturePath;
                    this.elements.add(se);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.gridWidth = 178;
        this.gridHeight = 124;
        this.gridLeft = (this.field_146294_l - this.gridWidth) / 2;
        this.gridTop = (this.field_146295_m - this.gridHeight) / 2 + 10;
        int buttonWidth = 90;
        int buttonHeight = 20;
        int spacing = 6;
        int buttonsLeft = this.gridLeft + this.gridWidth + 12;
        int buttonsTop = this.gridTop;
        this.nameFieldX = buttonsLeft;
        this.nameFieldY = buttonsTop;
        if (this.nameField == null) {
            this.nameField = new GuiTextField(100, this.field_146289_q, this.nameFieldX, this.nameFieldY, 120, 18);
            this.nameField.func_146180_a(this.guiName);
            this.nameField.func_146203_f(32);
        } else {
            this.nameField.field_146209_f = this.nameFieldX;
            this.nameField.field_146210_g = this.nameFieldY;
        }
        this.field_146292_n.clear();
        this.btnSave = new GuiModernButton(0, buttonsLeft, buttonsTop + 24, buttonWidth, buttonHeight, "Save");
        this.btnCancel = new GuiModernButton(1, buttonsLeft, buttonsTop + 24 + (buttonHeight + spacing), buttonWidth, buttonHeight, "Cancel");
        this.btnAddSlot = new GuiModernButton(2, buttonsLeft, buttonsTop + 24 + 2 * (buttonHeight + spacing), buttonWidth, buttonHeight, "Add Slot");
        this.btnRemoveSlot = new GuiModernButton(3, buttonsLeft, buttonsTop + 24 + 3 * (buttonHeight + spacing), buttonWidth, buttonHeight, "Remove Slot");
        if (this.nameField != null) {
            this.guiName = this.nameField.func_146179_b();
        }
        this.field_146292_n.add(this.btnSave);
        this.field_146292_n.add(this.btnCancel);
        this.field_146292_n.add(this.btnAddSlot);
        this.field_146292_n.add(this.btnRemoveSlot);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int color;
        int y;
        int x;
        this.func_146276_q_();
        String title = TextFormatting.BOLD + "GUI Builder" + TextFormatting.RESET + " - " + this.guiName;
        this.func_73732_a(this.field_146289_q, title, this.field_146294_l / 2, this.gridTop - 20, 0xFFFFFF);
        String mode = this.addMode ? TextFormatting.GREEN + "Add mode: Click an empty cell to place a slot" : TextFormatting.GRAY + "Tip: Click Add Slot to place new slots";
        this.func_73732_a(this.field_146289_q, mode, this.field_146294_l / 2, this.gridTop - 8, 0xAAAAAA);
        this.drawPanel(this.gridLeft, this.gridTop, this.gridWidth, this.gridHeight, -1442840576);
        int hoveredCol = this.getGridCol(mouseX);
        int hoveredRow = this.getGridRow(mouseY);
        for (int r = 0; r < 6; ++r) {
            for (int c = 0; c < 9; ++c) {
                x = this.gridLeft + 8 + c * 18;
                y = this.gridTop + 8 + r * 18;
                color = -14013910;
                if (c == hoveredCol && r == hoveredRow) {
                    color = -12961222;
                }
                this.drawSlotRect(x, y, 16, 16, color);
            }
        }
        this.field_146289_q.func_78276_b("Name:", this.nameFieldX, this.nameFieldY - 10, 0xFFFFFF);
        if (this.nameField != null) {
            this.nameField.func_146194_f();
        }
        for (SlotElement e : this.elements) {
            ResourceLocation rl;
            x = this.cellX(e.col);
            y = this.cellY(e.row);
            if (e.texturePath != null && !e.texturePath.isEmpty() && (rl = TextureCache.get(e.texturePath)) != null) {
                float prevZ = this.field_73735_i;
                this.field_73735_i = -90.0f;
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_146297_k.func_110434_K().func_110577_a(rl);
                GuiCustomGuiBuilder.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                GlStateManager.func_179141_d();
                GlStateManager.func_179084_k();
                this.field_73735_i = prevZ;
            }
            color = e == this.selected ? -10048769 : -7697782;
            this.drawSlotBorder(x, y, 16, 16, color);
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawPanel(int x, int y, int w, int h, int color) {
        GuiCustomGuiBuilder.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
        int borderColor = 0x55FFFFFF;
        this.func_73730_a(x, x + w, y, borderColor);
        this.func_73730_a(x, x + w, y + h, borderColor);
        this.func_73728_b(x, y, y + h, borderColor);
        this.func_73728_b(x + w, y, y + h, borderColor);
    }

    private void drawSlotBorder(int x, int y, int w, int h, int color) {
        int border = color;
        this.func_73730_a(x, x + w, y, border);
        this.func_73730_a(x, x + w, y + h, border);
        this.func_73728_b(x, y, y + h, border);
        this.func_73728_b(x + w, y, y + h, border);
    }

    private void drawSlotRect(int x, int y, int w, int h, int color) {
        GuiCustomGuiBuilder.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)color);
        int border = -12303292;
        this.func_73730_a(x, x + w, y, border);
        this.func_73730_a(x, x + w, y + h, border);
        this.func_73728_b(x, y, y + h, border);
        this.func_73728_b(x + w, y, y + h, border);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.btnSave) {
            CustomGuiDef def = new CustomGuiDef();
            def.name = this.guiName;
            def.cols = 9;
            def.rows = 6;
            for (SlotElement e : this.elements) {
                GuiElementDef ged = new GuiElementDef();
                ged.col = e.col;
                ged.row = e.row;
                ged.leftClickCommand = e.leftAction;
                ged.rightClickCommand = e.rightAction;
                ged.middleClickCommand = e.middleAction;
                ged.leftExecuteAsPlayer = e.leftAsPlayer;
                ged.rightExecuteAsPlayer = e.rightAsPlayer;
                ged.middleExecuteAsPlayer = e.middleAsPlayer;
                ged.texturePath = e.texturePath;
                def.elements.add(ged);
            }
            try {
                Gson g = new Gson();
                String json = g.toJson((Object)def);
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketSaveCustomGui(json));
                this.field_146297_k.field_71439_g.func_71165_d("Saved GUI '" + this.guiName + "'");
                Minecraft.func_71410_x().func_147108_a(null);
            }
            catch (Exception ex) {
                this.field_146297_k.field_71439_g.func_71165_d("Error saving GUI: " + ex.getMessage());
            }
        } else if (button == this.btnCancel) {
            Minecraft.func_71410_x().func_147108_a(null);
        } else if (button == this.btnAddSlot) {
            this.addMode = true;
        } else if (button == this.btnRemoveSlot) {
            this.removeMode = true;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int col = this.getGridCol(mouseX);
        int row = this.getGridRow(mouseY);
        if (this.nameField != null) {
            this.nameField.func_146192_a(mouseX, mouseY, mouseButton);
        }
        if (col >= 0 && row >= 0 && col < 9 && row < 6) {
            SlotElement at = this.getElementAt(col, row);
            if (this.addMode) {
                if (at == null) {
                    this.elements.add(new SlotElement(col, row));
                }
                this.addMode = false;
            } else if (this.removeMode) {
                if (at != null) {
                    this.elements.remove(at);
                }
                this.removeMode = false;
            } else if (at != null) {
                SlotElement target = at;
                this.field_146297_k.func_147108_a((GuiScreen)new GuiSlotEditorOverlay(this, at.col, at.row, at.leftAction, at.rightAction, at.middleAction, at.texturePath, (c, r, left, right, middle, texture, leftAsPlayer, rightAsPlayer, middleAsPlayer) -> {
                    target.leftAction = left;
                    target.rightAction = right;
                    target.middleAction = middle;
                    target.texturePath = texture;
                    target.leftAsPlayer = leftAsPlayer;
                    target.rightAsPlayer = rightAsPlayer;
                    target.middleAsPlayer = middleAsPlayer;
                }));
            }
        }
    }

    private int getGridCol(int mouseX) {
        int insideX = mouseX - (this.gridLeft + 8);
        if (insideX < 0) {
            return -1;
        }
        int col = insideX / 18;
        if (col >= 9) {
            return -1;
        }
        return col;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.nameField != null && this.nameField.func_146201_a(typedChar, keyCode)) {
            this.guiName = this.nameField.func_146179_b();
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.nameField != null) {
            this.nameField.func_146178_a();
        }
    }

    private int getGridRow(int mouseY) {
        int insideY = mouseY - (this.gridTop + 8);
        if (insideY < 0) {
            return -1;
        }
        int row = insideY / 18;
        if (row >= 6) {
            return -1;
        }
        return row;
    }

    private int cellX(int col) {
        return this.gridLeft + 8 + col * 18;
    }

    private int cellY(int row) {
        return this.gridTop + 8 + row * 18;
    }

    @Nullable
    private SlotElement getElementAt(int col, int row) {
        for (SlotElement e : this.elements) {
            if (e.col != col || e.row != row) continue;
            return e;
        }
        return null;
    }

    public boolean func_73868_f() {
        return false;
    }

    private static class SlotElement {
        final int col;
        final int row;
        @Nullable
        String leftAction;
        @Nullable
        String rightAction;
        @Nullable
        String middleAction;
        @Nullable
        String texturePath;
        boolean leftAsPlayer;
        boolean rightAsPlayer;
        boolean middleAsPlayer;

        SlotElement(int col, int row) {
            this.col = col;
            this.row = row;
        }
    }
}

