/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.builder.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiDef;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class CustomGuiStorage {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static File getBaseDir() {
        File configDir = FMLCommonHandler.instance().getMinecraftServerInstance() != null ? new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n(), "config") : new File("config");
        File dir = new File(configDir, "mw_guis");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File fileFor(@Nonnull String name) {
        return new File(CustomGuiStorage.getBaseDir(), name + ".json");
    }

    public static File getTextureDir() {
        File dir = new File(CustomGuiStorage.getBaseDir(), "textures");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void save(@Nonnull CustomGuiDef def) throws IOException {
        File f = CustomGuiStorage.fileFor(def.name);
        try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8);){
            GSON.toJson((Object)def, (Appendable)w);
        }
    }

    @Nullable
    public static CustomGuiDef load(@Nonnull String name) throws IOException {
        File f = CustomGuiStorage.fileFor(name);
        if (!f.exists()) {
            return null;
        }
        try (InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8);){
            CustomGuiDef customGuiDef = (CustomGuiDef)GSON.fromJson((Reader)r, CustomGuiDef.class);
            return customGuiDef;
        }
    }

    public static boolean delete(@Nonnull String name) {
        File f = CustomGuiStorage.fileFor(name);
        return f.exists() && f.delete();
    }

    @Nonnull
    public static List<String> listAll() {
        File base = CustomGuiStorage.getBaseDir();
        File[] files = base.listFiles((dir, name) -> name.endsWith(".json"));
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (File f : files) {
            String n = f.getName();
            names.add(n.substring(0, n.length() - 5));
        }
        return names;
    }
}

