/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.builder.texture;

import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiStorage;
import de.sarocesch.minewacheroleplaymod.texture.ClientTextureCache;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.util.ResourceLocation;

public class TextureCache {
    private static final Map<String, ResourceLocation> CACHE = new HashMap<String, ResourceLocation>();

    public static ResourceLocation get(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return CACHE.computeIfAbsent(path, p -> {
            try {
                File serverCache = ClientTextureCache.getCacheDir();
                File f = new File(serverCache, (String)p);
                if (!f.exists()) {
                    File texDir = CustomGuiStorage.getTextureDir();
                    f = new File(texDir, (String)p);
                }
                System.out.println("[MW-GUI] TextureCache lookup: " + f.getAbsolutePath());
                if (!f.exists()) {
                    System.out.println("[MW-GUI] Texture not found: " + f);
                    return null;
                }
                BufferedImage img = ImageIO.read(f);
                if (img == null) {
                    System.out.println("[MW-GUI] Failed to decode image: " + f);
                    return null;
                }
                DynamicTexture dyn = new DynamicTexture(img);
                ResourceLocation rl = Minecraft.func_71410_x().func_110434_K().func_110578_a("mw_gui/" + Math.abs(p.hashCode()), dyn);
                System.out.println("[MW-GUI] Loaded texture " + p + " -> " + rl);
                return rl;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        });
    }
}

