/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone.apps;

import de.sarocesch.minewacheroleplaymod.gui.phone.CameraCaptureHooks;
import de.sarocesch.minewacheroleplaymod.gui.phone.FullscreenImageScreen;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneScreen;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneAddPhoto;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneDeletePhoto;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotoThumb;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotos;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class CameraApp
implements PhoneApp {
    private PhoneScreen host;
    private Mode mode = Mode.CAMERA;
    private int lastW;
    private int lastH;
    private int thumbX;
    private int thumbY;
    private int thumbS = 28;
    private int captureScale = 2;
    private int shX;
    private int shY;
    private int shR;
    private long pressedUntil = 0L;
    private DynamicTexture previewTex;
    private ResourceLocation previewRL;
    private int prevPW = -1;
    private int prevPH = -1;
    private boolean captureArmed = false;
    private boolean requestedList = false;
    private final Set<String> requestedThumbs = new HashSet<String>();
    private boolean galleryDirty = false;
    private int galScroll = 0;
    private int camBtnX;
    private int camBtnY;
    private int camBtnW = 64;
    private int camBtnH = 16;
    private int delX;
    private int delY;
    private int delW = 16;
    private int delH = 16;
    private boolean confirmDelete = false;
    private String previewId = null;

    @Override
    public String getTitle() {
        return "Camera";
    }

    @Override
    public String getIconLabel() {
        return "CAM";
    }

    @Override
    public void setHost(PhoneScreen host) {
        this.host = host;
    }

    @Override
    public void onOpen() {
        this.mode = Mode.CAMERA;
        this.requestedList = false;
        this.previewId = null;
        this.confirmDelete = false;
    }

    @Override
    public void prePhoneUiDraw(Minecraft mc, int contentX, int contentY, int contentW, int contentH, int screenW, int screenH, float pt) {
        if (contentW <= 0 || contentH <= 0) {
            return;
        }
        int fbW = mc.field_71443_c;
        int fbH = mc.field_71440_d;
        float sx = (float)fbW / (float)screenW;
        float sy = (float)fbH / (float)screenH;
        int px = Math.max(0, Math.round((float)contentX * sx));
        int py = Math.max(0, Math.round((float)(screenH - (contentY + contentH)) * sy));
        int pw = Math.max(1, Math.round((float)contentW * sx));
        int ph = Math.max(1, Math.round((float)contentH * sy));
        float zoomOut = 1.25f;
        int srcW = Math.min(fbW, Math.max(1, Math.round((float)pw * zoomOut)));
        int srcH = Math.min(fbH, Math.max(1, Math.round((float)ph * zoomOut)));
        int cx = px + pw / 2;
        int cy = py + ph / 2;
        int sx0 = Math.max(0, Math.min(fbW - srcW, cx - srcW / 2));
        int sy0 = Math.max(0, Math.min(fbH - srcH, cy - srcH / 2));
        this.ensurePreviewTexture(mc, srcW, srcH);
        if (this.previewTex != null) {
            GlStateManager.func_179144_i((int)this.previewTex.func_110552_b());
            GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)sx0, (int)sy0, (int)srcW, (int)srcH);
        }
        if (this.captureArmed && CameraCaptureHooks.shouldCaptureThisFrame()) {
            File saved;
            BufferedImage bi = this.grabFullFramebuffer(fbW, fbH);
            if (bi != null && (saved = this.saveScreenshotToFile(mc, bi)) != null) {
                this.onCaptured(bi, saved);
            }
            this.captureArmed = false;
            CameraCaptureHooks.disarm();
        }
        CameraCaptureHooks.tickArmed();
    }

    private void ensurePreviewTexture(Minecraft mc, int w, int h) {
        if (this.previewTex == null || w != this.prevPW || h != this.prevPH) {
            this.previewTex = new DynamicTexture(w, h);
            this.previewRL = mc.func_110434_K().func_110578_a("phone_cam_preview", this.previewTex);
            this.prevPW = w;
            this.prevPH = h;
        }
    }

    @Override
    public void draw(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY, float pt) {
        this.lastW = w;
        this.lastH = h;
        if (this.mode == Mode.CAMERA) {
            this.drawCamera(mc, x, y, w, h, mouseX, mouseY);
        } else if (this.mode == Mode.GALLERY) {
            if (!this.requestedList && this.host != null) {
                this.requestedList = true;
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotos(this.host.getHandIndex()));
            }
            this.drawGallery(mc, x, y, w, h, mouseX, mouseY);
        } else {
            this.drawPreview(mc, x, y, w, h);
        }
    }

    private void drawCamera(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY) {
        if (this.previewRL != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.func_110434_K().func_110577_a(this.previewRL);
            Gui.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)w, (int)h, (float)this.prevPW, (float)this.prevPH);
        } else {
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)0x33000000);
        }
        int gx1 = x + w / 3;
        int gx2 = x + 2 * w / 3;
        int gy1 = y + h / 3;
        int gy2 = y + 2 * h / 3;
        Gui.func_73734_a((int)gx1, (int)(y + 18), (int)(gx1 + 1), (int)(y + h - 24), (int)0x40FFFFFF);
        Gui.func_73734_a((int)gx2, (int)(y + 18), (int)(gx2 + 1), (int)(y + h - 24), (int)0x40FFFFFF);
        Gui.func_73734_a((int)(x + 6), (int)gy1, (int)(x + w - 6), (int)(gy1 + 1), (int)0x40FFFFFF);
        Gui.func_73734_a((int)(x + 6), (int)gy2, (int)(x + w - 6), (int)(gy2 + 1), (int)0x40FFFFFF);
        Gui.func_73734_a((int)(x + 2), (int)(y + 18), (int)(x + w - 2), (int)(y + 19), (int)0x55FFFFFF);
        Gui.func_73734_a((int)(x + 2), (int)(y + h - 24), (int)(x + w - 2), (int)(y + h - 23), (int)0x55FFFFFF);
        Gui.func_73734_a((int)(x + 2), (int)(y + 18), (int)(x + 3), (int)(y + h - 24), (int)0x55FFFFFF);
        Gui.func_73734_a((int)(x + w - 3), (int)(y + 18), (int)(x + w - 2), (int)(y + h - 24), (int)0x55FFFFFF);
        this.shR = Math.max(20, Math.min(26, Math.min(w, h) / 7));
        this.shX = w / 2;
        this.shY = h - 28;
        boolean pressed = System.currentTimeMillis() < this.pressedUntil;
        int shadow = 0x55000000;
        int ring = pressed ? -3355444 : -1;
        this.fillCircle(x + this.shX + 1, y + this.shY + 1, this.shR + 1, shadow);
        this.fillCircle(x + this.shX, y + this.shY, this.shR, ring);
        this.fillCircle(x + this.shX, y + this.shY, Math.max(1, this.shR - 4), -1710101);
        this.thumbS = 28;
        this.thumbX = 8;
        this.thumbY = h - this.thumbS - 10;
        if (!PhoneClientState.photos.isEmpty()) {
            PhoneClientState.PhotoMeta pm = PhoneClientState.photos.get(0);
            ResourceLocation rl = PhoneClientState.photoThumbs.get(pm.id);
            if (rl != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                Gui.func_146110_a((int)(x + this.thumbX), (int)(y + this.thumbY), (float)0.0f, (float)0.0f, (int)this.thumbS, (int)this.thumbS, (float)this.thumbS, (float)this.thumbS);
                Gui.func_73734_a((int)(x + this.thumbX - 1), (int)(y + this.thumbY - 1), (int)(x + this.thumbX + this.thumbS + 1), (int)(y + this.thumbY + this.thumbS + 1), (int)-2013265920);
            } else if (this.host != null) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotoThumb(this.host.getHandIndex(), pm.id));
                Gui.func_73734_a((int)(x + this.thumbX), (int)(y + this.thumbY), (int)(x + this.thumbX + this.thumbS), (int)(y + this.thumbY + this.thumbS), (int)-13947341);
            }
        } else {
            Gui.func_73734_a((int)(x + this.thumbX), (int)(y + this.thumbY), (int)(x + this.thumbX + this.thumbS), (int)(y + this.thumbY + this.thumbS), (int)-13947341);
            Gui.func_73734_a((int)(x + this.thumbX + this.thumbS / 2 - 1), (int)(y + this.thumbY + 4), (int)(x + this.thumbX + this.thumbS / 2 + 1), (int)(y + this.thumbY + this.thumbS - 4), (int)-1);
            Gui.func_73734_a((int)(x + this.thumbX + 4), (int)(y + this.thumbY + this.thumbS / 2 - 1), (int)(x + this.thumbX + this.thumbS - 4), (int)(y + this.thumbY + this.thumbS / 2 + 1), (int)-1);
        }
    }

    private void drawGallery(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY) {
        int top = y + 24;
        int left = x + 6;
        int right = x + w - 6;
        int bottom = y + h - 6;
        int cols = Math.max(1, (w - 12) / 104);
        int size = 96;
        int gap = 8;
        int rowH = size + gap;
        this.camBtnX = 6;
        this.camBtnY = 4;
        this.camBtnW = 64;
        this.camBtnH = 16;
        Gui.func_73734_a((int)(x + this.camBtnX), (int)(y + this.camBtnY), (int)(x + this.camBtnX + this.camBtnW), (int)(y + this.camBtnY + this.camBtnH), (int)-13947341);
        mc.field_71466_p.func_78276_b("Camera", x + this.camBtnX + 14, y + this.camBtnY + 4, -1);
        for (int i = 0; i < PhoneClientState.photos.size(); ++i) {
            int col = i % cols;
            int row = i / cols;
            int ix = left + col * (size + gap);
            int iy = top + row * rowH - this.galScroll;
            if (iy > bottom) break;
            if (iy + size < top) continue;
            PhoneClientState.PhotoMeta pm = PhoneClientState.photos.get(i);
            ResourceLocation rl = PhoneClientState.photoThumbs.get(pm.id);
            if (rl != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                Gui.func_146110_a((int)ix, (int)iy, (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
                continue;
            }
            Gui.func_73734_a((int)ix, (int)iy, (int)(ix + size), (int)(iy + size), (int)-13947341);
            if (this.host == null || !this.requestedThumbs.add(pm.id)) continue;
            NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotoThumb(this.host.getHandIndex(), pm.id));
        }
        Gui.func_73734_a((int)(right - 3), (int)top, (int)right, (int)bottom, (int)0x33000000);
    }

    private static BufferedImage scaleToSquare(BufferedImage src, int size) {
        BufferedImage out = new BufferedImage(size, size, 2);
        Graphics2D g = out.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        int sw = src.getWidth();
        int sh = src.getHeight();
        float scale = Math.min((float)size / (float)sw, (float)size / (float)sh);
        int dw = Math.round((float)sw * scale);
        int dh = Math.round((float)sh * scale);
        int dx = (size - dw) / 2;
        int dy = (size - dh) / 2;
        g.drawImage(src, dx, dy, dx + dw, dy + dh, 0, 0, sw, sh, null);
        g.dispose();
        return out;
    }

    private void fillCircle(int cx, int cy, int r, int color) {
        if (r <= 0) {
            return;
        }
        int a = color >>> 24 & 0xFF;
        int rgb = color & 0xFFFFFF;
        for (int dy = -r; dy <= r; ++dy) {
            int dx = (int)Math.floor(Math.sqrt(r * r - dy * dy));
            Gui.func_73734_a((int)(cx - dx), (int)(cy + dy), (int)(cx + dx + 1), (int)(cy + dy + 1), (int)(a << 24 | rgb));
        }
    }

    private void drawPreview(Minecraft mc, int x, int y, int w, int h) {
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h), (int)-872415232);
        if (this.previewId != null) {
            ResourceLocation rl = PhoneClientState.photoThumbs.get(this.previewId);
            int size = Math.min(192, Math.min(w - 40, h - 60));
            int px = x + (w - size) / 2;
            int py = y + (h - size) / 2;
            if (rl != null) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                Gui.func_146110_a((int)px, (int)py, (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
            } else {
                Gui.func_73734_a((int)px, (int)py, (int)(px + size), (int)(py + size), (int)-13947341);
            }
            int btnW = 60;
            int btnH = 16;
            Gui.func_73734_a((int)(x + 10), (int)(y + h - btnH - 10), (int)(x + 10 + btnW), (int)(y + h - 10), (int)-13947341);
            mc.field_71466_p.func_78276_b("Back", x + 10 + 18, y + h - btnH - 10 + 4, -1);
            Gui.func_73734_a((int)(x + w - 10 - btnW), (int)(y + h - btnH - 10), (int)(x + w - 10), (int)(y + h - 10), (int)-12944642);
            mc.field_71466_p.func_78276_b("Fullscreen", x + w - 10 - btnW + 6, y + h - btnH - 10 + 4, -1);
            this.delW = 16;
            this.delH = 16;
            this.delX = w - this.delW - 6;
            this.delY = 6;
            Gui.func_73734_a((int)(x + this.delX), (int)(y + this.delY), (int)(x + this.delX + this.delW), (int)(y + this.delY + this.delH), (int)-2087900);
            Gui.func_73734_a((int)(x + this.delX + 3), (int)(y + this.delY + 3), (int)(x + this.delX + this.delW - 3), (int)(y + this.delY + 4), (int)-1);
            Gui.func_73734_a((int)(x + this.delX + 3), (int)(y + this.delY + this.delH - 4), (int)(x + this.delX + this.delW - 3), (int)(y + this.delY + this.delH - 3), (int)-1);
            if (this.confirmDelete) {
                int dw = Math.min(140, w - 40);
                int dh = 60;
                int dx = x + (w - dw) / 2;
                int dy = y + (h - dh) / 2;
                Gui.func_73734_a((int)dx, (int)dy, (int)(dx + dw), (int)(dy + dh), (int)-299947721);
                mc.field_71466_p.func_78276_b("Delete photo?", dx + 10, dy + 10, -1);
                int ybW = 40;
                int ybH = 14;
                int yesX = dx + 12;
                int yesY = dy + dh - ybH - 10;
                int noX = dx + dw - ybW - 12;
                int noY = yesY;
                Gui.func_73734_a((int)yesX, (int)yesY, (int)(yesX + ybW), (int)(yesY + ybH), (int)-2087900);
                mc.field_71466_p.func_78276_b("Yes", yesX + 12, yesY + 3, -1);
                Gui.func_73734_a((int)noX, (int)noY, (int)(noX + ybW), (int)(noY + ybH), (int)-13947341);
                mc.field_71466_p.func_78276_b("No", noX + 14, noY + 3, -1);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.mode == Mode.CAMERA) {
            int dx = mouseX - this.shX;
            int dy = mouseY - this.shY;
            if (dx * dx + dy * dy <= this.shR * this.shR) {
                this.pressedUntil = System.currentTimeMillis() + 140L;
                this.captureArmed = true;
                CameraCaptureHooks.armCleanCaptureForNextFrame();
                return;
            }
            if (mouseX >= this.thumbX && mouseX <= this.thumbX + this.thumbS && mouseY >= this.thumbY && mouseY <= this.thumbY + this.thumbS) {
                this.mode = Mode.GALLERY;
                if (!this.requestedList && this.host != null) {
                    this.requestedList = true;
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotos(this.host.getHandIndex()));
                }
                return;
            }
        } else if (this.mode == Mode.GALLERY) {
            int idx;
            if (mouseX >= this.camBtnX && mouseX <= this.camBtnX + this.camBtnW && mouseY >= this.camBtnY && mouseY <= this.camBtnY + this.camBtnH) {
                this.mode = Mode.CAMERA;
                return;
            }
            int left = 6;
            int top = 24;
            int size = 96;
            int gap = 8;
            int cols = Math.max(1, (this.lastW - 12) / 104);
            int col = (mouseX - left) / (size + gap);
            int row = (mouseY - top + this.galScroll) / (size + gap);
            if (col >= 0 && col < cols && row >= 0 && (idx = row * cols + col) >= 0 && idx < PhoneClientState.photos.size()) {
                int ix = left + col * (size + gap);
                int iy = top + row * (size + gap) - this.galScroll;
                if (mouseX >= ix && mouseX <= ix + size && mouseY >= iy && mouseY <= iy + size) {
                    this.previewId = PhoneClientState.photos.get((int)idx).id;
                    this.mode = Mode.PREVIEW;
                    this.confirmDelete = false;
                    return;
                }
            }
        } else if (this.mode == Mode.PREVIEW) {
            if (this.confirmDelete) {
                int dw = Math.min(140, this.lastW - 40);
                int dh = 60;
                int dx = (this.lastW - dw) / 2;
                int dy = (this.lastH - dh) / 2;
                int ybW = 40;
                int ybH = 14;
                int yesX = dx + 12;
                int yesY = dy + dh - ybH - 10;
                int noX = dx + dw - ybW - 12;
                int noY = yesY;
                if (mouseX >= yesX && mouseX <= yesX + ybW && mouseY >= yesY && mouseY <= yesY + ybH) {
                    if (this.host != null && this.previewId != null) {
                        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneDeletePhoto(this.host.getHandIndex(), this.previewId));
                        Iterator<PhoneClientState.PhotoMeta> it = PhoneClientState.photos.iterator();
                        while (it.hasNext()) {
                            if (!it.next().id.equals(this.previewId)) continue;
                            it.remove();
                            break;
                        }
                        PhoneClientState.photoThumbs.remove(this.previewId);
                    }
                    this.mode = Mode.GALLERY;
                    this.previewId = null;
                    this.confirmDelete = false;
                    return;
                }
                if (mouseX >= noX && mouseX <= noX + ybW && mouseY >= noY && mouseY <= noY + ybH) {
                    this.confirmDelete = false;
                    return;
                }
                return;
            }
            int btnW = 60;
            int btnH = 16;
            int backX = 10;
            int backY = this.lastH - btnH - 10;
            int fsX = this.lastW - 10 - btnW;
            int fsY = backY;
            if (mouseX >= backX && mouseX <= backX + btnW && mouseY >= backY && mouseY <= backY + btnH) {
                this.mode = Mode.GALLERY;
                return;
            }
            if (mouseX >= fsX && mouseX <= fsX + btnW && mouseY >= fsY && mouseY <= fsY + btnH) {
                if (this.previewId != null) {
                    File dir;
                    File f;
                    PhoneClientState.PhotoMeta pm = null;
                    for (PhoneClientState.PhotoMeta p : PhoneClientState.photos) {
                        if (!p.id.equals(this.previewId)) continue;
                        pm = p;
                        break;
                    }
                    if (pm != null && (f = new File(dir = new File(Minecraft.func_71410_x().field_71412_D, "screenshots"), pm.name)).exists()) {
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new FullscreenImageScreen(f));
                    }
                }
                return;
            }
            if (mouseX >= this.delX && mouseX <= this.delX + this.delW && mouseY >= this.delY && mouseY <= this.delY + this.delH) {
                this.confirmDelete = true;
                return;
            }
        }
    }

    private void onCaptured(BufferedImage bi, File saved) {
        this.galleryDirty = true;
        try {
            String id = UUID.randomUUID().toString();
            long ts = System.currentTimeMillis();
            BufferedImage th = CameraApp.scaleToSquare(bi, 96);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)th, "PNG", baos);
            byte[] png = baos.toByteArray();
            if (this.host != null) {
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneAddPhoto(this.host.getHandIndex(), id, ts, bi.getWidth(), bi.getHeight(), saved.getName(), png));
            }
            PhoneClientState.PhotoMeta pm = new PhoneClientState.PhotoMeta();
            pm.id = id;
            pm.ts = ts;
            pm.w = bi.getWidth();
            pm.h = bi.getHeight();
            pm.name = saved.getName();
            PhoneClientState.photos.add(0, pm);
            PhoneClientState.putThumb(id, th);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void mouseScrolled(int delta) {
        if (this.mode == Mode.GALLERY) {
            int step = 20 * Integer.signum(-delta);
            this.galScroll = Math.max(0, this.galScroll + step);
        }
    }

    private BufferedImage grabFullFramebuffer(int w, int h) {
        try {
            ByteBuffer buf = ByteBuffer.allocateDirect(w * h * 4);
            GL11.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (ByteBuffer)buf);
            BufferedImage img = new BufferedImage(w, h, 2);
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int i = (x + w * y) * 4;
                    int r = buf.get(i) & 0xFF;
                    int g = buf.get(i + 1) & 0xFF;
                    int b = buf.get(i + 2) & 0xFF;
                    int a = buf.get(i + 3) & 0xFF;
                    img.setRGB(x, h - 1 - y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            return img;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private File saveScreenshotToFile(Minecraft mc, BufferedImage img) {
        try {
            File dir = new File(mc.field_71412_D, "screenshots");
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String ts = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
            File out = new File(dir, "camera_" + ts + ".png");
            ImageIO.write((RenderedImage)img, "PNG", out);
            return out;
        }
        catch (IOException e) {
            return null;
        }
    }

    private void captureHighResAndSave() {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            ScreenShotHelper.func_148260_a((File)mc.field_71412_D, (int)mc.field_71443_c, (int)mc.field_71440_d, (Framebuffer)mc.func_147110_a());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static enum Mode {
        CAMERA,
        GALLERY,
        PREVIEW;

    }
}

