/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.gui.phone.apps;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneApp;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneScreen;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotoThumb;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotos;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneSendImage;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneSendMessage;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessagesApp
implements PhoneApp {
    private PhoneScreen host;
    private String openConv = null;
    private boolean openIsGroup = false;
    private GuiTextField input;
    private int attachRelX;
    private int attachRelY;
    private int attachRelW;
    private int attachRelH;
    private int inputRelX;
    private int inputRelY;
    private int inputRelW;
    private int inputRelH;
    private int sendRelX;
    private int sendRelY;
    private int sendRelW;
    private int sendRelH;
    private boolean selectingPhoto = false;
    private int selectScroll = 0;
    private int selCols = 1;
    private int selLeft = 6;
    private int selTop = 6;
    private int selSize = 72;
    private int selGap = 6;
    private String selectedPhotoId = null;
    private GuiTextField captionField;
    private int lastW = 0;
    private int lastH = 0;

    @Override
    public void setHost(PhoneScreen host) {
        this.host = host;
    }

    @Override
    public String getTitle() {
        if (this.openConv == null) {
            return "Messages";
        }
        String title = this.openIsGroup ? this.openConv : PhoneClientState.nicknames.getOrDefault(this.openConv, this.openConv);
        return "Chat: " + title;
    }

    @Override
    public String getIconLabel() {
        return "MSG";
    }

    @Override
    public void onOpen() {
        this.input = null;
        this.selectingPhoto = false;
    }

    @Override
    public boolean onBack() {
        if (this.selectingPhoto) {
            this.selectingPhoto = false;
            return true;
        }
        if (this.openConv != null) {
            this.openConv = null;
            return true;
        }
        return false;
    }

    @Override
    public void draw(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY, float pt) {
        if (this.openConv == null) {
            this.drawConversationList(mc, x, y, w, h, mouseX, mouseY);
        } else {
            this.drawConversation(mc, x, y, w, h, mouseX, mouseY);
        }
    }

    private void drawConversationList(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY) {
        for (Map.Entry<String, Boolean> e : PhoneClientState.online.entrySet()) {
            String p;
            if (!Boolean.TRUE.equals(e.getValue()) || (p = e.getKey()).equals(PhoneClientState.self())) continue;
            PhoneClientState.conversations.computeIfAbsent(p, id -> {
                PhoneClientState.Conversation cc = new PhoneClientState.Conversation();
                cc.id = id;
                cc.group = false;
                cc.title = id;
                return cc;
            });
        }
        ArrayList<PhoneClientState.Conversation> list = new ArrayList<PhoneClientState.Conversation>(PhoneClientState.conversations.values());
        list.sort(Comparator.comparingLong(c -> -(c.messages.isEmpty() ? 0L : c.messages.get((int)(c.messages.size() - 1)).ts)));
        int rowH = 26;
        int yPos = y;
        for (PhoneClientState.Conversation c2 : list) {
            Gui.func_73734_a((int)x, (int)yPos, (int)(x + w), (int)(yPos + rowH - 1), (int)858467891);
            String title = c2.title;
            if (PhoneClientState.nicknames.containsKey(c2.id)) {
                title = PhoneClientState.nicknames.get(c2.id);
            }
            String last = "";
            if (!c2.messages.isEmpty()) {
                PhoneClientState.Message lm = c2.messages.get(c2.messages.size() - 1);
                last = lm.isImage ? "[image]" : lm.text;
            }
            mc.field_71466_p.func_78276_b(title, x + 6, yPos + 6, 0xFFFFFF);
            if (!last.isEmpty()) {
                mc.field_71466_p.func_78276_b(MessagesApp.trim(last, 22), x + 6, yPos + 16, 0xAAAAAA);
            }
            if (c2.unread > 0) {
                String badge = String.valueOf(c2.unread);
                int bw = 8 + mc.field_71466_p.func_78256_a(badge);
                int bx = x + w - bw - 6;
                Gui.func_73734_a((int)bx, (int)(yPos + 6), (int)(bx + bw), (int)(yPos + 6 + 12), (int)-12944642);
                mc.field_71466_p.func_78276_b(badge, bx + 4, yPos + 9, 0xFFFFFF);
            }
            if ((yPos += rowH) <= y + h - rowH) continue;
            break;
        }
    }

    private void drawConversation(Minecraft mc, int x, int y, int w, int h, int mouseX, int mouseY) {
        int inputH = 18;
        int headerH = 18;
        Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + headerH), (int)-14803165);
        String title = PhoneClientState.nicknames.getOrDefault(this.openConv, this.openConv);
        mc.field_71466_p.func_78276_b(title, x + 6, y + 5, 0xFFFFFF);
        int statusColor = -5592406;
        String status = "";
        Boolean on = PhoneClientState.online.get(this.openConv);
        if (on != null && on.booleanValue()) {
            status = "Online";
            statusColor = -11751600;
        } else {
            Long ls = PhoneClientState.lastSeen.get(this.openConv);
            if (ls != null) {
                long mins = Math.max(0L, (System.currentTimeMillis() - ls) / 60000L);
                String string = status = mins == 0L ? "Last seen just now" : "Last seen " + mins + " min ago";
            }
        }
        if (!status.isEmpty()) {
            mc.field_71466_p.func_78276_b(status, x + w - 6 - mc.field_71466_p.func_78256_a(status), y + 5, statusColor);
        }
        int hx = x;
        int hy = y + headerH;
        int hw = w;
        int hh = h - inputH - 4 - headerH;
        int yPos = hy + hh - 4;
        List<PhoneClientState.Message> msgs = PhoneClientState.conversations.get((Object)this.openConv).messages;
        for (int i = msgs.size() - 1; i >= 0; --i) {
            int by;
            int bx;
            int boxH;
            int boxW;
            PhoneClientState.Message m = msgs.get(i);
            boolean self = m.from.equals(PhoneClientState.self());
            int pad = 4;
            if (m.isImage && m.imageId != null) {
                ResourceLocation rl = PhoneClientState.photoThumbs.get(m.imageId);
                int size = 96;
                boxW = size + 2 * pad;
                boxH = size + 2 * pad;
                bx = self ? hx + hw - boxW - 6 : hx + 6;
                by = yPos - boxH;
                Gui.func_73734_a((int)bx, (int)by, (int)(bx + boxW), (int)(by + boxH), (int)(self ? -12944642 : -13947341));
                if (rl != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                    Gui.func_146110_a((int)(bx + pad), (int)(by + pad), (float)0.0f, (float)0.0f, (int)size, (int)size, (float)size, (float)size);
                } else {
                    mc.field_71466_p.func_78276_b("[image]", bx + pad + 4, by + pad + 24, 0xFFFFFF);
                }
            } else {
                String text = MessagesApp.formatMsg(m);
                int maxTextW = hw - 20 - 2 * pad;
                List lines = mc.field_71466_p.func_78271_c(text, Math.max(40, maxTextW));
                int lineH = mc.field_71466_p.field_78288_b + 1;
                int widest = 0;
                for (String ln : lines) {
                    widest = Math.max(widest, mc.field_71466_p.func_78256_a(ln));
                }
                boxW = Math.min(hw - 20, widest + 2 * pad);
                boxH = 2 * pad + lines.size() * lineH;
                bx = self ? hx + hw - boxW - 6 : hx + 6;
                by = yPos - boxH;
                Gui.func_73734_a((int)bx, (int)by, (int)(bx + boxW), (int)(by + boxH), (int)(self ? -12944642 : -13947341));
                int ty = by + pad + 1;
                for (String ln : lines) {
                    mc.field_71466_p.func_78276_b(ln, bx + pad, ty, 0xFFFFFF);
                    ty += lineH;
                }
            }
            yPos = by - 4;
            if (yPos < hy) break;
        }
        this.attachRelX = 4;
        this.attachRelY = h - inputH + 1;
        this.attachRelW = 22;
        this.attachRelH = inputH - 2;
        Gui.func_73734_a((int)(x + this.attachRelX), (int)(y + this.attachRelY), (int)(x + this.attachRelX + this.attachRelW), (int)(y + this.attachRelY + this.attachRelH), (int)-13947341);
        int cx = x + this.attachRelX + this.attachRelW / 2;
        int cy = y + this.attachRelY + this.attachRelH / 2;
        Gui.func_73734_a((int)(cx - 1), (int)(y + this.attachRelY + 4), (int)(cx + 1), (int)(y + this.attachRelY + this.attachRelH - 4), (int)-1);
        Gui.func_73734_a((int)(x + this.attachRelX + 4), (int)(cy - 1), (int)(x + this.attachRelX + this.attachRelW - 4), (int)(cy + 1), (int)-1);
        this.inputRelX = this.attachRelX + this.attachRelW + 4;
        this.inputRelY = h - inputH + 1;
        this.inputRelW = w - (this.attachRelW + 4) - 48 - 8;
        this.inputRelH = inputH - 2;
        if (this.input == null) {
            this.input = new GuiTextField(3001, mc.field_71466_p, x + this.inputRelX, y + this.inputRelY, this.inputRelW, this.inputRelH);
            this.input.func_146203_f(256);
            this.input.func_146195_b(true);
        } else {
            this.input.field_146209_f = x + this.inputRelX;
            this.input.field_146210_g = y + this.inputRelY;
            this.input.field_146218_h = this.inputRelW;
            this.input.field_146219_i = this.inputRelH;
        }
        this.input.func_146194_f();
        this.sendRelW = 36;
        this.sendRelH = this.inputRelH;
        this.sendRelX = this.inputRelX + this.inputRelW + 4;
        this.sendRelY = this.inputRelY;
        Gui.func_73734_a((int)(x + this.sendRelX), (int)(y + this.sendRelY), (int)(x + this.sendRelX + this.sendRelW), (int)(y + this.sendRelY + this.sendRelH), (int)-12944642);
        mc.field_71466_p.func_78276_b("Send", x + this.sendRelX + 8, y + this.sendRelY + 4, 0xFFFFFF);
        if (this.selectingPhoto) {
            Gui.func_73734_a((int)x, (int)y, (int)(x + w), (int)(y + h - inputH), (int)-1442840576);
            this.lastW = w;
            this.lastH = h;
            this.selTop = y + 6;
            this.selLeft = x + 6;
            this.selSize = 72;
            this.selGap = 6;
            this.selCols = Math.max(1, (w - 12) / (this.selSize + this.selGap));
            int rowH = this.selSize + this.selGap;
            int bottom = y + h - inputH - 30;
            for (int i = 0; i < PhoneClientState.photos.size(); ++i) {
                int border;
                int col = i % this.selCols;
                int row = i / this.selCols;
                int ix = this.selLeft + col * (this.selSize + this.selGap);
                int iy = this.selTop + row * rowH - this.selectScroll;
                if (iy > bottom) break;
                if (iy + this.selSize < this.selTop) continue;
                PhoneClientState.PhotoMeta pm = PhoneClientState.photos.get(i);
                ResourceLocation rl = PhoneClientState.photoThumbs.get(pm.id);
                int n = border = pm.id.equals(this.selectedPhotoId) ? -12944642 : 0;
                if (rl != null) {
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(rl);
                    Gui.func_146110_a((int)ix, (int)iy, (float)0.0f, (float)0.0f, (int)this.selSize, (int)this.selSize, (float)this.selSize, (float)this.selSize);
                } else {
                    Gui.func_73734_a((int)ix, (int)iy, (int)(ix + this.selSize), (int)(iy + this.selSize), (int)-13947341);
                    if (this.host != null) {
                        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotoThumb(this.host.getHandIndex(), pm.id));
                    }
                }
                if (border == 0) continue;
                Gui.func_73734_a((int)(ix - 1), (int)(iy - 1), (int)(ix + this.selSize + 1), (int)(iy + this.selSize + 1), (int)border);
            }
            int capX = x + 6;
            int capY = y + h - inputH - 22;
            int capW = w - 6 - 6 - 52;
            int capH = 18;
            if (this.captionField == null) {
                this.captionField = new GuiTextField(3002, mc.field_71466_p, capX, capY, capW, capH);
                this.captionField.func_146203_f(200);
            } else {
                this.captionField.field_146209_f = capX;
                this.captionField.field_146210_g = capY;
                this.captionField.field_146218_h = capW;
                this.captionField.field_146219_i = capH;
            }
            this.captionField.func_146194_f();
            int sendX = capX + capW + 6;
            int sendY = capY;
            int sendW = 46;
            int sendH = capH;
            Gui.func_73734_a((int)sendX, (int)sendY, (int)(sendX + sendW), (int)(sendY + sendH), (int)(this.selectedPhotoId != null ? -12944642 : -11184811));
            mc.field_71466_p.func_78276_b("Send", sendX + 10, sendY + 4, -1);
            mc.field_71466_p.func_78276_b(this.selectedPhotoId == null ? "Select a photo" : "Add a caption", x + 8, y + 4, 0xFFFFFF);
        }
    }

    private static String trim(String s, int len) {
        return s.length() <= len ? s : s.substring(0, len - 3) + "...";
    }

    private static String formatMsg(PhoneClientState.Message m) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm");
        String t = df.format(new Date(m.ts));
        return "[" + t + "] " + m.from + ": " + m.text;
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        Minecraft mc = Minecraft.func_71410_x();
        if (this.openConv == null) {
            int rowH = 26;
            int idx = mouseY / rowH;
            ArrayList<PhoneClientState.Conversation> list = new ArrayList<PhoneClientState.Conversation>(PhoneClientState.conversations.values());
            list.sort(Comparator.comparingLong(c -> -(c.messages.isEmpty() ? 0L : c.messages.get((int)(c.messages.size() - 1)).ts)));
            if (idx >= 0 && idx < list.size()) {
                PhoneClientState.Conversation c2 = (PhoneClientState.Conversation)list.get(idx);
                this.openConv = c2.id;
                this.openIsGroup = c2.group;
                c2.unread = 0;
                if (this.input != null) {
                    this.input.func_146195_b(true);
                }
            }
        } else {
            if (this.selectingPhoto) {
                int idx;
                int col = (mouseX - this.selLeft) / (this.selSize + this.selGap);
                int row = (mouseY - this.selTop + this.selectScroll) / (this.selSize + this.selGap);
                if (col >= 0 && col < this.selCols && row >= 0 && (idx = row * this.selCols + col) >= 0 && idx < PhoneClientState.photos.size()) {
                    int cellY = this.selTop + row * (this.selSize + this.selGap) - this.selectScroll;
                    int cellX = this.selLeft + col * (this.selSize + this.selGap);
                    if (mouseY >= cellY && mouseY <= cellY + this.selSize && mouseX >= cellX && mouseX <= cellX + this.selSize) {
                        this.selectedPhotoId = PhoneClientState.photos.get((int)idx).id;
                        if (this.captionField != null) {
                            this.captionField.func_146195_b(true);
                        }
                        return;
                    }
                }
                int inputH = 18;
                int capX = 6;
                int capY = this.lastH - inputH - 22;
                int capW = this.lastW - 6 - 6 - 52;
                int capH = 18;
                int sendX = capX + capW + 6;
                int sendY = capY;
                int sendW = 46;
                int sendH = capH;
                if (mouseX >= capX && mouseX <= capX + capW && mouseY >= capY && mouseY <= capY + capH) {
                    if (this.captionField != null) {
                        this.captionField.func_146195_b(true);
                    }
                    return;
                }
                if (mouseX >= sendX && mouseX <= sendX + sendW && mouseY >= sendY && mouseY <= sendY + sendH) {
                    if (this.selectedPhotoId != null) {
                        String cap = this.captionField != null ? this.captionField.func_146179_b() : "";
                        this.sendPhoto(this.selectedPhotoId, cap);
                        this.selectedPhotoId = null;
                        if (this.captionField != null) {
                            this.captionField.func_146180_a("");
                        }
                    }
                    return;
                }
                this.selectingPhoto = false;
                return;
            }
            if (this.input != null && mouseX >= this.inputRelX && mouseX <= this.inputRelX + this.inputRelW && mouseY >= this.inputRelY && mouseY <= this.inputRelY + this.inputRelH) {
                this.input.func_146195_b(true);
            }
            if (mouseX >= this.attachRelX && mouseX <= this.attachRelX + this.attachRelW && mouseY >= this.attachRelY && mouseY <= this.attachRelY + this.attachRelH) {
                this.selectingPhoto = true;
                if (this.host != null) {
                    NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneRequestPhotos(this.host.getHandIndex()));
                }
                return;
            }
            if (mouseX >= this.sendRelX && mouseX <= this.sendRelX + this.sendRelW && mouseY >= this.sendRelY && mouseY <= this.sendRelY + this.sendRelH) {
                this.sendCurrent();
            }
        }
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.openConv != null) {
            if (this.selectingPhoto) {
                if (this.captionField != null) {
                    this.captionField.func_146201_a(typedChar, keyCode);
                }
            } else if (this.input != null) {
                if (keyCode == 28 || keyCode == 156) {
                    this.sendCurrent();
                    return;
                }
                if (ChatAllowedCharacters.func_71566_a((char)typedChar) || keyCode == 14) {
                    this.input.func_146201_a(typedChar, keyCode);
                }
            }
        }
    }

    @Override
    public void mouseScrolled(int delta) {
        if (this.selectingPhoto) {
            this.selectScroll = Math.max(0, this.selectScroll + 20 * Integer.signum(-delta));
        }
    }

    private void sendCurrent() {
        if (this.openConv == null || this.input == null) {
            return;
        }
        String text = this.input.func_146179_b().trim();
        if (text.isEmpty()) {
            return;
        }
        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneSendMessage(this.openConv, this.openIsGroup, text));
        this.input.func_146180_a("");
    }

    private void sendPhoto(String id) {
        this.sendPhoto(id, "");
    }

    private void sendPhoto(String id, String caption) {
        if (this.host == null || this.openConv == null) {
            return;
        }
        NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketPhoneSendImage(this.host.getHandIndex(), this.openConv, this.openIsGroup, id, caption));
    }

    @Override
    public boolean blocksPlayerMovement() {
        return this.input != null && this.input.func_146206_l() || this.captionField != null && this.captionField.func_146206_l();
    }

    @Override
    public boolean capturesOutsideClicks() {
        return this.selectingPhoto;
    }
}

