/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.listener;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class StartCommandsJoin
extends ElementsMinewacheRolePlayMod.ModElement {
    private Configuration config;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public StartCommandsJoin(ElementsMinewacheRolePlayMod instance) {
        super(instance, 75);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        this.config = new Configuration(new File(directory.getPath(), "minewache-start-commands.cfg"));
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void serverLoad(FMLServerStartingEvent event) {
        try {
            String line;
            FileReader reader = new FileReader(this.config.getConfigFile());
            BufferedReader br = new BufferedReader(reader);
            int lineNumber = 1;
            while ((line = br.readLine()) != null) {
                if (!line.trim().isEmpty() && !line.trim().startsWith("#")) {
                    String commandLine = line.substring(1).trim();
                    char firstChar = line.charAt(0);
                    if (firstChar != 'p' && firstChar == 's') {
                        this.scheduler.schedule(() -> event.getServer().func_71187_D().func_71556_a((ICommandSender)event.getServer(), commandLine), 5L, TimeUnit.SECONDS);
                    }
                }
                ++lineNumber;
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executePlayerCommand(FMLServerStartingEvent event, String commandLine) {
        EntityPlayerMP player = event.getServer().func_184103_al().func_181057_v().stream().findFirst().orElse(null);
        if (player != null) {
            event.getServer().func_71187_D().func_71556_a((ICommandSender)player, commandLine);
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            try {
                String line;
                FileReader reader = new FileReader(this.config.getConfigFile());
                BufferedReader br = new BufferedReader(reader);
                int lineNumber = 1;
                while ((line = br.readLine()) != null) {
                    if (!line.trim().isEmpty() && !line.trim().startsWith("#")) {
                        String commandLine = line.substring(1).trim();
                        char firstChar = line.charAt(0);
                        if (firstChar == 'p') {
                            this.scheduler.schedule(() -> player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player, commandLine), 5L, TimeUnit.SECONDS);
                        } else if (firstChar == 'g') {
                            String[] parts = commandLine.split(" ", 2);
                            if (parts.length == 2) {
                                String uuid = parts[0];
                                String command = parts[1];
                                this.scheduler.schedule(() -> this.executeUUIDCommand(player, uuid, command), 5L, TimeUnit.SECONDS);
                            } else {
                                System.err.println("Ung\ufffdltige Formatierung in Zeile " + lineNumber);
                            }
                        } else {
                            System.err.println("Ung\ufffdltiges erstes Zeichen in Zeile " + lineNumber);
                        }
                    }
                    ++lineNumber;
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void executeUUIDCommand(EntityPlayerMP player, String uuid, String command) {
        if (player.func_110124_au().toString().equals(uuid)) {
            player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player, command);
        } else {
            System.err.println("Spieler " + player.func_70005_c_() + " hat nicht die UUID " + uuid);
        }
    }

    @Override
    public void registerModels(ModelRegistryEvent event) {
    }
}

