/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.navi.core;

import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class NaviRoadDetector {
    private NaviRoadDetector() {
    }

    public static boolean isRoad(World world, BlockPos pos) {
        for (int i = 0; i <= 3; ++i) {
            IBlockState state = world.func_180495_p(pos.func_177979_c(i));
            Block block = state.func_177230_c();
            ResourceLocation name = block.getRegistryName();
            if (name == null || !Dateiverwaltung.NaviItems.contains(name.toString())) continue;
            return true;
        }
        return false;
    }

    public static BlockPos highestNonAir(World world, BlockPos pos) {
        BlockPos cur = pos;
        while (!world.func_175623_d(cur.func_177984_a())) {
            cur = cur.func_177984_a();
        }
        return cur;
    }

    public static BlockPos centerOnRoad(World world, BlockPos pos, BlockPos prev, BlockPos next) {
        int dx = (next != null ? next.func_177958_n() : pos.func_177958_n()) - (prev != null ? prev.func_177958_n() : pos.func_177958_n());
        int dz = (next != null ? next.func_177952_p() : pos.func_177952_p()) - (prev != null ? prev.func_177952_p() : pos.func_177952_p());
        EnumFacing forward = Math.abs(dx) >= Math.abs(dz) ? (dx >= 0 ? EnumFacing.EAST : EnumFacing.WEST) : (dz >= 0 ? EnumFacing.SOUTH : EnumFacing.NORTH);
        EnumFacing left = forward.func_176746_e();
        EnumFacing right = forward.func_176735_f();
        int leftWidth = NaviRoadDetector.scanWidth(world, pos, left);
        int rightWidth = NaviRoadDetector.scanWidth(world, pos, right);
        int offset = (rightWidth - leftWidth) / 2;
        BlockPos centered = pos.func_177967_a(right, Math.max(0, offset)).func_177967_a(left, Math.max(0, -offset));
        BlockPos highest = NaviRoadDetector.highestNonAir(world, centered);
        return highest;
    }

    private static int scanWidth(World world, BlockPos origin, EnumFacing side) {
        int width = 0;
        BlockPos cur = origin;
        for (int i = 1; i <= 8 && NaviRoadDetector.isRoad(world, cur = cur.func_177972_a(side)); ++i) {
            ++width;
        }
        return width;
    }
}

