/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketExecuteGuiAction
implements IMessage {
    private String command;
    private boolean executeAsPlayer;

    public PacketExecuteGuiAction() {
    }

    public PacketExecuteGuiAction(String command, boolean executeAsPlayer) {
        this.command = command;
        this.executeAsPlayer = executeAsPlayer;
    }

    public void toBytes(ByteBuf buf) {
        byte[] b = this.command.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
        buf.writeBoolean(this.executeAsPlayer);
    }

    public void fromBytes(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        this.command = new String(b, StandardCharsets.UTF_8);
        this.executeAsPlayer = buf.readBoolean();
    }

    public static class Handler
    implements IMessageHandler<PacketExecuteGuiAction, IMessage> {
        public IMessage onMessage(PacketExecuteGuiAction msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                if (msg.command != null && !msg.command.isEmpty()) {
                    String cmd = msg.command.replace("{Player}", player.func_70005_c_());
                    if (msg.executeAsPlayer) {
                        player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player, cmd);
                    } else {
                        player.func_184102_h().func_71187_D().func_71556_a((ICommandSender)player.func_184102_h(), cmd);
                    }
                }
            });
            return null;
        }
    }
}

