/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.gui.builder.GuiCustomDisplay;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketOpenCustomGui
implements IMessage {
    private String name;
    private String json;

    public PacketOpenCustomGui() {
    }

    public PacketOpenCustomGui(String name) {
        this.name = name;
    }

    public PacketOpenCustomGui(String name, String json) {
        this.name = name;
        this.json = json;
    }

    public void toBytes(ByteBuf buf) {
        byte[] nb = this.name.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(nb.length);
        buf.writeBytes(nb);
        if (this.json == null) {
            this.json = "";
        }
        byte[] jb = this.json.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(jb.length);
        buf.writeBytes(jb);
    }

    public void fromBytes(ByteBuf buf) {
        int nlen = buf.readInt();
        byte[] nb = new byte[nlen];
        buf.readBytes(nb);
        this.name = new String(nb, StandardCharsets.UTF_8);
        int jlen = buf.readInt();
        byte[] jb = new byte[jlen];
        buf.readBytes(jb);
        this.json = new String(jb, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketOpenCustomGui, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketOpenCustomGui message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                GuiCustomDisplay screen = new GuiCustomDisplay(message.name);
                if (message.json != null && !message.json.isEmpty()) {
                    screen.loadFromJson(message.json);
                }
                Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
            });
            return null;
        }
    }
}

