/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network;

import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneAddPhoto;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneDeletePhoto;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneInitialSync;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhonePhotoThumb;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhonePhotosList;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneReceiveImage;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneReceiveMessage;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotoThumb;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestPhotos;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneRequestSync;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneSendImage;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneSendMessage;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneUpdateSettings;
import de.sarocesch.minewacheroleplaymod.network.phone.PhonePresenceData;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ServerHandlers {
    public static void sendInitialSync(EntityPlayerMP player, int handIndex) {
        Object names;
        NBTTagCompound tag;
        PacketPhoneInitialSync sync = new PacketPhoneInitialSync();
        ItemStack stack = ServerHandlers.findPhoneStack(player, handIndex);
        NBTTagCompound phone = new NBTTagCompound();
        if (!stack.func_190926_b() && (tag = stack.func_77978_p()) != null) {
            phone = tag.func_74775_l("mw_phone");
        }
        sync.darkTheme = !phone.func_74764_b("darkTheme") || phone.func_74767_n("darkTheme");
        sync.scale = phone.func_74764_b("scale") ? phone.func_74760_g("scale") : 1.0f;
        sync.sounds = !phone.func_74764_b("sounds") || phone.func_74767_n("sounds");
        sync.privacy = phone.func_74764_b("privacy") ? phone.func_74779_i("privacy") : "everyone";
        sync.readReceipts = !phone.func_74764_b("readReceipts") || phone.func_74767_n("readReceipts");
        sync.background = phone.func_74764_b("background") ? phone.func_74779_i("background") : "default_dark.png";
        NBTTagCompound nicks = phone.func_74775_l("nicknames");
        Set keys = nicks.func_150296_c();
        for (String k : keys) {
            sync.nicknames.put(k, nicks.func_74779_i(k));
        }
        HashMap<String, Boolean> online = new HashMap<String, Boolean>();
        HashMap<String, Long> lastSeen = new HashMap<String, Long>();
        PlayerProfileCache cache = player.func_184102_h().func_152358_ax();
        if (cache != null && (names = cache.func_152654_a()) != null) {
            for (String n : names) {
                online.put(n, false);
            }
        }
        for (EntityPlayerMP p : player.func_184102_h().func_184103_al().func_181057_v()) {
            online.put(p.func_70005_c_(), true);
        }
        PhonePresenceData data = PhonePresenceData.get(player.field_70170_p);
        if (data != null) {
            lastSeen.putAll(data.getLastSeen());
        }
        sync.online = online;
        sync.lastSeen = lastSeen;
        NetworkHandler.INSTANCE.sendTo((IMessage)sync, player);
    }

    public static void sendInitialSync(EntityPlayerMP player) {
        ServerHandlers.sendInitialSync(player, 0);
    }

    private static ItemStack findPhoneStack(EntityPlayerMP player, int handIndex) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        if (handIndex == 0 && ServerHandlers.isPhone(main)) {
            return main;
        }
        if (handIndex == 1 && ServerHandlers.isPhone(off)) {
            return off;
        }
        if (ServerHandlers.isPhone(main)) {
            return main;
        }
        if (ServerHandlers.isPhone(off)) {
            return off;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack s = player.field_71071_by.func_70301_a(i);
            if (!ServerHandlers.isPhone(s)) continue;
            return s;
        }
        return ItemStack.field_190927_a;
    }

    private static boolean isPhone(ItemStack s) {
        if (s == null || s.func_190926_b()) {
            return false;
        }
        Item it = s.func_77973_b();
        ResourceLocation rl = it.getRegistryName();
        if (rl == null) {
            return false;
        }
        String key = rl.toString();
        return "saros_new_blocks_mod:iphone".equals(key) || "saros_new_blocks_mod:samsung".equals(key);
    }

    private static String ensureDeviceId(ItemStack stack) {
        NBTTagCompound phone;
        String id;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        String string = id = (phone = tag.func_74775_l("mw_phone")).func_74764_b("deviceId") ? phone.func_74779_i("deviceId") : null;
        if (id == null || id.isEmpty()) {
            id = UUID.randomUUID().toString();
            phone.func_74778_a("deviceId", id);
            tag.func_74782_a("mw_phone", (NBTBase)phone);
            stack.func_77982_d(tag);
        }
        return id;
    }

    public static class PhoneSendImageHandler
    implements IMessageHandler<PacketPhoneSendImage, IMessage> {
        public IMessage onMessage(PacketPhoneSendImage msg, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            sender.func_71121_q().func_152344_a(() -> {
                ItemStack stack = ServerHandlers.findPhoneStack(sender, msg.hand);
                if (stack.func_190926_b()) {
                    return;
                }
                String deviceId = ServerHandlers.ensureDeviceId(stack);
                long ts = System.currentTimeMillis();
                String mid = UUID.randomUUID().toString();
                byte[] png = new byte[]{};
                try {
                    File worldDir = sender.field_70170_p.func_72860_G().func_75765_b();
                    File file = new File(new File(worldDir, "mw_phone/photos/" + deviceId + "/thumbs"), msg.imageId + ".png");
                    if (file.exists()) {
                        png = Files.readAllBytes(file.toPath());
                    }
                }
                catch (Exception worldDir) {
                    // empty catch block
                }
                if (!msg.group) {
                    EntityPlayerMP to = sender.func_184102_h().func_184103_al().func_152612_a(msg.to);
                    if (to != null) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveImage(mid, sender.func_70005_c_(), msg.to, false, ts, msg.imageId, msg.caption, png), to);
                    }
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveImage(mid, sender.func_70005_c_(), msg.to, false, ts, msg.imageId, msg.caption, png), sender);
                } else {
                    for (EntityPlayerMP p : sender.func_184102_h().func_184103_al().func_181057_v()) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveImage(mid, sender.func_70005_c_(), msg.to, true, ts, msg.imageId, msg.caption, png), p);
                    }
                }
            });
            return null;
        }
    }

    public static class PhoneDeletePhotoHandler
    implements IMessageHandler<PacketPhoneDeletePhoto, IMessage> {
        public IMessage onMessage(PacketPhoneDeletePhoto msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                NBTTagCompound phone;
                NBTTagCompound photos;
                ItemStack stack = ServerHandlers.findPhoneStack(player, msg.hand);
                if (stack.func_190926_b()) {
                    return;
                }
                String deviceId = ServerHandlers.ensureDeviceId(stack);
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                if ((photos = (phone = tag.func_74775_l("mw_phone")).func_74775_l("photos")).func_74764_b(msg.id)) {
                    photos.func_82580_o(msg.id);
                    phone.func_74782_a("photos", (NBTBase)photos);
                    tag.func_74782_a("mw_phone", (NBTBase)phone);
                    stack.func_77982_d(tag);
                }
                try {
                    File worldDir = player.field_70170_p.func_72860_G().func_75765_b();
                    File file = new File(new File(worldDir, "mw_phone/photos/" + deviceId + "/thumbs"), msg.id + ".png");
                    if (file.exists()) {
                        file.delete();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return null;
        }
    }

    public static class PhoneRequestPhotoThumbHandler
    implements IMessageHandler<PacketPhoneRequestPhotoThumb, IMessage> {
        public IMessage onMessage(PacketPhoneRequestPhotoThumb msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack stack = ServerHandlers.findPhoneStack(player, msg.hand);
                if (stack.func_190926_b()) {
                    return;
                }
                String deviceId = ServerHandlers.ensureDeviceId(stack);
                try {
                    File worldDir = player.field_70170_p.func_72860_G().func_75765_b();
                    File file = new File(new File(worldDir, "mw_phone/photos/" + deviceId + "/thumbs"), msg.id + ".png");
                    byte[] data = file.exists() ? Files.readAllBytes(file.toPath()) : new byte[]{};
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhonePhotoThumb(msg.id, data), player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return null;
        }
    }

    public static class PhoneRequestPhotosHandler
    implements IMessageHandler<PacketPhoneRequestPhotos, IMessage> {
        public IMessage onMessage(PacketPhoneRequestPhotos msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack stack = ServerHandlers.findPhoneStack(player, msg.hand);
                NBTTagCompound phone = new NBTTagCompound();
                if (!stack.func_190926_b() && stack.func_77978_p() != null) {
                    phone = stack.func_77978_p().func_74775_l("mw_phone");
                }
                NBTTagCompound photos = phone.func_74775_l("photos");
                PacketPhonePhotosList out = new PacketPhonePhotosList();
                Set ids = photos.func_150296_c();
                ArrayList<PacketPhonePhotosList.Photo> list = new ArrayList<PacketPhonePhotosList.Photo>();
                for (String id : ids) {
                    NBTTagCompound p = photos.func_74775_l(id);
                    PacketPhonePhotosList.Photo ph = new PacketPhonePhotosList.Photo();
                    ph.id = id;
                    ph.ts = p.func_74763_f("ts");
                    ph.w = p.func_74762_e("w");
                    ph.h = p.func_74762_e("h");
                    ph.name = p.func_74779_i("name");
                    list.add(ph);
                }
                out.list = list;
                NetworkHandler.INSTANCE.sendTo((IMessage)out, player);
            });
            return null;
        }
    }

    public static class PhoneAddPhotoHandler
    implements IMessageHandler<PacketPhoneAddPhoto, IMessage> {
        public IMessage onMessage(PacketPhoneAddPhoto msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack stack = ServerHandlers.findPhoneStack(player, msg.hand);
                if (stack.func_190926_b()) {
                    return;
                }
                String deviceId = ServerHandlers.ensureDeviceId(stack);
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                NBTTagCompound phone = tag.func_74775_l("mw_phone");
                NBTTagCompound photos = phone.func_74775_l("photos");
                NBTTagCompound p = new NBTTagCompound();
                p.func_74772_a("ts", msg.ts);
                p.func_74768_a("w", msg.w);
                p.func_74768_a("h", msg.h);
                p.func_74778_a("name", msg.name);
                photos.func_74782_a(msg.id, (NBTBase)p);
                phone.func_74782_a("photos", (NBTBase)photos);
                tag.func_74782_a("mw_phone", (NBTBase)phone);
                stack.func_77982_d(tag);
                try {
                    File worldDir = player.field_70170_p.func_72860_G().func_75765_b();
                    File dir = new File(worldDir, "mw_phone/photos/" + deviceId + "/thumbs");
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    File out = new File(dir, msg.id + ".png");
                    if (msg.thumbPng != null && msg.thumbPng.length > 0) {
                        Files.write(out.toPath(), msg.thumbPng, new OpenOption[0]);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            return null;
        }
    }

    public static class PhoneRequestSyncHandler
    implements IMessageHandler<PacketPhoneRequestSync, IMessage> {
        public IMessage onMessage(PacketPhoneRequestSync msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            int handIndex = msg != null ? msg.hand : 0;
            player.func_71121_q().func_152344_a(() -> ServerHandlers.sendInitialSync(player, handIndex));
            return null;
        }
    }

    public static class PhoneUpdateSettingsHandler
    implements IMessageHandler<PacketPhoneUpdateSettings, IMessage> {
        public IMessage onMessage(PacketPhoneUpdateSettings msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                int handIndex = msg != null ? msg.hand : 0;
                ItemStack stack = ServerHandlers.findPhoneStack(player, handIndex);
                if (stack.func_190926_b()) {
                    return;
                }
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                NBTTagCompound phone = tag.func_74775_l("mw_phone");
                phone.func_74757_a("darkTheme", msg.darkTheme);
                phone.func_74776_a("scale", msg.scale);
                phone.func_74757_a("sounds", msg.sounds);
                phone.func_74778_a("privacy", msg.privacy);
                phone.func_74757_a("readReceipts", msg.readReceipts);
                if (msg.background != null) {
                    phone.func_74778_a("background", msg.background);
                }
                tag.func_74782_a("mw_phone", (NBTBase)phone);
                stack.func_77982_d(tag);
                ServerHandlers.sendInitialSync(player, handIndex);
            });
            return null;
        }
    }

    public static class PhoneSendHandler
    implements IMessageHandler<PacketPhoneSendMessage, IMessage> {
        public IMessage onMessage(PacketPhoneSendMessage msg, MessageContext ctx) {
            EntityPlayerMP sender = ctx.getServerHandler().field_147369_b;
            sender.func_71121_q().func_152344_a(() -> {
                long ts = System.currentTimeMillis();
                String id = UUID.randomUUID().toString();
                if (!msg.group) {
                    EntityPlayerMP to = sender.func_184102_h().func_184103_al().func_152612_a(msg.to);
                    if (to != null) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveMessage(id, sender.func_70005_c_(), msg.to, false, ts, msg.text), to);
                    }
                    NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveMessage(id, sender.func_70005_c_(), msg.to, false, ts, msg.text), sender);
                } else {
                    for (EntityPlayerMP p : sender.func_184102_h().func_184103_al().func_181057_v()) {
                        NetworkHandler.INSTANCE.sendTo((IMessage)new PacketPhoneReceiveMessage(id, sender.func_70005_c_(), msg.to, true, ts, msg.text), p);
                    }
                }
            });
            return null;
        }
    }
}

