/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketPhoneAddPhoto
implements IMessage {
    public int hand;
    public String id;
    public long ts;
    public int w;
    public int h;
    public String name;
    public byte[] thumbPng;

    public PacketPhoneAddPhoto() {
    }

    public PacketPhoneAddPhoto(int hand, String id, long ts, int w, int h, String name, byte[] thumbPng) {
        this.hand = hand;
        this.id = id;
        this.ts = ts;
        this.w = w;
        this.h = h;
        this.name = name;
        this.thumbPng = thumbPng;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.hand);
        PacketPhoneAddPhoto.writeString(buf, this.id);
        buf.writeLong(this.ts);
        buf.writeInt(this.w);
        buf.writeInt(this.h);
        PacketPhoneAddPhoto.writeString(buf, this.name);
        if (this.thumbPng == null) {
            buf.writeInt(0);
        } else {
            buf.writeInt(this.thumbPng.length);
            buf.writeBytes(this.thumbPng);
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readUnsignedByte();
        this.id = PacketPhoneAddPhoto.readString(buf);
        this.ts = buf.readLong();
        this.w = buf.readInt();
        this.h = buf.readInt();
        this.name = PacketPhoneAddPhoto.readString(buf);
        int len = buf.readInt();
        if (len > 0) {
            this.thumbPng = new byte[len];
            buf.readBytes(this.thumbPng);
        } else {
            this.thumbPng = new byte[0];
        }
    }

    static void writeString(ByteBuf buf, String s) {
        if (s == null) {
            s = "";
        }
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeShort(b.length);
        buf.writeBytes(b);
    }

    static String readString(ByteBuf buf) {
        int l = buf.readUnsignedShort();
        byte[] b = new byte[l];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }
}

