/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.gui.phone.PhoneClientState;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketPhoneReceiveMessage
implements IMessage {
    public String id;
    public String from;
    public String to;
    public boolean group;
    public long ts;
    public String text;

    public PacketPhoneReceiveMessage() {
    }

    public PacketPhoneReceiveMessage(String id, String from, String to, boolean group, long ts, String text) {
        this.id = id;
        this.from = from;
        this.to = to;
        this.group = group;
        this.ts = ts;
        this.text = text;
    }

    public void toBytes(ByteBuf buf) {
        PacketPhoneReceiveMessage.writeString(buf, this.id);
        PacketPhoneReceiveMessage.writeString(buf, this.from);
        PacketPhoneReceiveMessage.writeString(buf, this.to);
        buf.writeBoolean(this.group);
        buf.writeLong(this.ts);
        PacketPhoneReceiveMessage.writeString(buf, this.text);
    }

    public void fromBytes(ByteBuf buf) {
        this.id = PacketPhoneReceiveMessage.readString(buf);
        this.from = PacketPhoneReceiveMessage.readString(buf);
        this.to = PacketPhoneReceiveMessage.readString(buf);
        this.group = buf.readBoolean();
        this.ts = buf.readLong();
        this.text = PacketPhoneReceiveMessage.readString(buf);
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneReceiveMessage, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketPhoneReceiveMessage msg, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                boolean incoming;
                PhoneClientState.Message m = new PhoneClientState.Message();
                m.id = msg.id;
                m.from = msg.from;
                m.to = msg.to;
                m.group = msg.group;
                m.ts = msg.ts;
                m.text = msg.text;
                boolean bl = incoming = !msg.from.equals(PhoneClientState.self());
                if (incoming) {
                    PhoneClientState.addIncoming(m);
                } else {
                    PhoneClientState.addOutgoing(m);
                }
                if (incoming && PhoneClientState.settings.sounds) {
                    try {
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)0.9f));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            });
            return null;
        }
    }
}

