/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketPhoneUpdateNicknames
implements IMessage {
    public int hand;
    public String player;
    public String nickname;

    public PacketPhoneUpdateNicknames() {
    }

    public PacketPhoneUpdateNicknames(int hand, String player, String nickname) {
        this.hand = hand;
        this.player = player;
        this.nickname = nickname;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.hand);
        PacketPhoneUpdateNicknames.writeString(buf, this.player);
        PacketPhoneUpdateNicknames.writeString(buf, this.nickname);
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readByte();
        this.player = PacketPhoneUpdateNicknames.readString(buf);
        this.nickname = PacketPhoneUpdateNicknames.readString(buf);
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public static class Handler
    implements IMessageHandler<PacketPhoneUpdateNicknames, IMessage> {
        public IMessage onMessage(PacketPhoneUpdateNicknames msg, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            player.func_71121_q().func_152344_a(() -> {
                ItemStack stack = this.findPhoneStack(player, msg.hand);
                if (stack.func_190926_b()) {
                    return;
                }
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                }
                NBTTagCompound phone = tag.func_74775_l("mw_phone");
                NBTTagCompound nicks = phone.func_74775_l("nicknames");
                nicks.func_74778_a(msg.player, msg.nickname);
                phone.func_74782_a("nicknames", (NBTBase)nicks);
                tag.func_74782_a("mw_phone", (NBTBase)phone);
                stack.func_77982_d(tag);
            });
            return null;
        }

        private ItemStack findPhoneStack(EntityPlayerMP player, int handIndex) {
            ItemStack main = player.func_184614_ca();
            ItemStack off = player.func_184592_cb();
            if (handIndex == 0 && this.isPhone(main)) {
                return main;
            }
            if (handIndex == 1 && this.isPhone(off)) {
                return off;
            }
            if (this.isPhone(main)) {
                return main;
            }
            if (this.isPhone(off)) {
                return off;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack s = player.field_71071_by.func_70301_a(i);
                if (!this.isPhone(s)) continue;
                return s;
            }
            return ItemStack.field_190927_a;
        }

        private boolean isPhone(ItemStack s) {
            if (s == null || s.func_190926_b()) {
                return false;
            }
            Item it = s.func_77973_b();
            ResourceLocation rl = it.getRegistryName();
            if (rl == null) {
                return false;
            }
            String key = rl.toString();
            return "saros_new_blocks_mod:iphone".equals(key) || "saros_new_blocks_mod:samsung".equals(key);
        }
    }
}

