/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketPhoneUpdateSettings
implements IMessage {
    public int hand;
    public boolean darkTheme;
    public float scale;
    public boolean sounds;
    public String privacy;
    public boolean readReceipts;
    public String background;

    public PacketPhoneUpdateSettings() {
    }

    public PacketPhoneUpdateSettings(int hand, boolean darkTheme, float scale, boolean sounds, String privacy, boolean readReceipts, String background) {
        this.hand = hand;
        this.darkTheme = darkTheme;
        this.scale = scale;
        this.sounds = sounds;
        this.privacy = privacy;
        this.readReceipts = readReceipts;
        this.background = background;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.hand);
        buf.writeBoolean(this.darkTheme);
        buf.writeFloat(this.scale);
        buf.writeBoolean(this.sounds);
        PacketPhoneUpdateSettings.writeString(buf, this.privacy);
        buf.writeBoolean(this.readReceipts);
        PacketPhoneUpdateSettings.writeString(buf, this.background != null ? this.background : "default_dark.png");
    }

    public void fromBytes(ByteBuf buf) {
        this.hand = buf.readByte();
        this.darkTheme = buf.readBoolean();
        this.scale = buf.readFloat();
        this.sounds = buf.readBoolean();
        this.privacy = PacketPhoneUpdateSettings.readString(buf);
        this.readReceipts = buf.readBoolean();
        this.background = PacketPhoneUpdateSettings.readString(buf);
    }

    private static void writeString(ByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.writeInt(b.length);
        buf.writeBytes(b);
    }

    private static String readString(ByteBuf buf) {
        int len = buf.readInt();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }
}

