/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.network.phone;

import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.network.phone.PacketPhoneContacts;
import de.sarocesch.minewacheroleplaymod.network.phone.PhonePresenceData;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PhonePresence {
    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new PhonePresence());
    }

    @SubscribeEvent
    public void onLogin(PlayerEvent.PlayerLoggedInEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP p = (EntityPlayerMP)e.player;
        this.broadcastContacts(p);
    }

    @SubscribeEvent
    public void onLogout(PlayerEvent.PlayerLoggedOutEvent e) {
        if (!(e.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP p = (EntityPlayerMP)e.player;
        PhonePresenceData data = PhonePresenceData.get(p.field_70170_p);
        if (data != null) {
            data.markSeen(p.func_70005_c_(), System.currentTimeMillis());
        }
        this.broadcastContacts(p);
    }

    private void broadcastContacts(EntityPlayerMP context) {
        try {
            Object names;
            HashMap<String, Boolean> online = new HashMap<String, Boolean>();
            HashMap<String, Long> lastSeen = new HashMap<String, Long>();
            PlayerProfileCache cache = context.func_184102_h().func_152358_ax();
            if (cache != null && (names = cache.func_152654_a()) != null) {
                for (String n : names) {
                    online.put(n, false);
                }
            }
            for (EntityPlayerMP pl : context.func_184102_h().func_184103_al().func_181057_v()) {
                online.put(pl.func_70005_c_(), true);
            }
            PhonePresenceData data = PhonePresenceData.get(context.field_70170_p);
            if (data != null) {
                lastSeen.putAll(data.getLastSeen());
            }
            PacketPhoneContacts pkt = new PacketPhoneContacts();
            pkt.online = online;
            pkt.lastSeen = lastSeen;
            for (EntityPlayerMP pl : context.func_184102_h().func_184103_al().func_181057_v()) {
                NetworkHandler.INSTANCE.sendTo((IMessage)pkt, pl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

