/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.texture;

import de.sarocesch.minewacheroleplaymod.gui.builder.storage.CustomGuiStorage;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ClientTextureCache {
    private static final Map<String, List<byte[]>> PENDING = new HashMap<String, List<byte[]>>();
    private static final Set<String> EXPECTED = new HashSet<String>();
    private static File cacheDir;

    public static void onManifest(List<String> names) {
        try {
            cacheDir = new File(CustomGuiStorage.getBaseDir(), "server_cache");
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            EXPECTED.clear();
            EXPECTED.addAll(names);
            PENDING.clear();
            System.out.println("[MW-GUI] Manifest received: " + names.size() + " textures");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void onChunk(String name, int index, int total, byte[] data) {
        PENDING.computeIfAbsent(name, k -> new ArrayList<Object>(Collections.nCopies(total, null)));
        List<byte[]> lst = PENDING.get(name);
        lst.set(index, data);
        if (lst.stream().allMatch(Objects::nonNull)) {
            try {
                File out = new File(cacheDir, name);
                try (FileOutputStream fos = new FileOutputStream(out);){
                    for (int i = 0; i < total; ++i) {
                        fos.write(lst.get(i));
                    }
                }
                System.out.println("[MW-GUI] Received texture " + name + " (" + out.length() + " bytes)");
                PENDING.remove(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static File getCacheDir() {
        if (cacheDir == null) {
            ClientTextureCache.onManifest(Collections.emptyList());
        }
        return cacheDir;
    }
}

