/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod.utils;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.config.Dateiverwaltung;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicButtonUI;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@ElementsMinewacheRolePlayMod.ModElement.Tag
public class OptifineCheck
extends ElementsMinewacheRolePlayMod.ModElement {
    public OptifineCheck(ElementsMinewacheRolePlayMod instance) {
        super(instance, 327);
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (Dateiverwaltung.opti && !this.isOptiFineInstalled()) {
            this.openBlockingDialog();
        }
    }

    private void openBlockingDialog() {
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            SwingUtilities.invokeAndWait(() -> {
                final Color ACCENT = new Color(33, 150, 243);
                Color TEXT_PRIMARY = new Color(245, 245, 245);
                Color TEXT_SECONDARY = new Color(210, 210, 210);
                JDialog dialog = new JDialog((Frame)null, true);
                dialog.setUndecorated(true);
                dialog.setBackground(new Color(0, 0, 0, 0));
                dialog.setDefaultCloseOperation(0);
                dialog.setAlwaysOnTop(true);
                JPanel glass = new JPanel(new GridBagLayout()){

                    @Override
                    protected void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        Graphics2D g2 = (Graphics2D)g.create();
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        int w = this.getWidth();
                        int h = this.getHeight();
                        int arc = 24;
                        g2.setColor(new Color(ACCENT.getRed(), ACCENT.getGreen(), ACCENT.getBlue(), 90));
                        g2.setStroke(new BasicStroke(6.0f));
                        g2.drawRoundRect(3, 3, w - 6, h - 6, arc, arc);
                        g2.setColor(new Color(24, 24, 28, 220));
                        g2.fillRoundRect(0, 0, w, h, arc, arc);
                        g2.dispose();
                    }
                };
                glass.setOpaque(false);
                dialog.setContentPane(glass);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                gbc.insets = new Insets(20, 24, 8, 24);
                gbc.fill = 2;
                gbc.weightx = 1.0;
                JLabel title = new JLabel("Dieses Modpack ben\u00f6tigt OptiFine.", 0);
                title.setFont(new Font("SansSerif", 1, 20));
                title.setForeground(ACCENT);
                JLabel message = new JLabel("Bitte installiere OptiFine, sonst wird das Spiel beendet.", 0);
                message.setFont(new Font("SansSerif", 0, 14));
                message.setForeground(TEXT_SECONDARY);
                JPanel titlePanel = new JPanel(new GridLayout(2, 1, 0, 6));
                titlePanel.setOpaque(false);
                titlePanel.add(title);
                titlePanel.add(message);
                glass.add((Component)titlePanel, gbc);
                JPanel buttons = new JPanel(new GridLayout(1, 3, 12, 0));
                buttons.setOpaque(false);
                JButton download = new JButton("Download");
                JButton openMods = new JButton("Modordner");
                JButton quit = new JButton("Schlie\u00dfen");
                Font buttonFont = new Font("SansSerif", 1, 14);
                for (JButton b : new JButton[]{download, openMods, quit}) {
                    b.setFont(buttonFont);
                    b.setForeground(Color.WHITE);
                    b.setBorder(BorderFactory.createEmptyBorder(10, 14, 10, 14));
                    b.setContentAreaFilled(false);
                    b.setOpaque(false);
                    b.setFocusPainted(false);
                    b.setRolloverEnabled(true);
                    b.setUI(new BasicButtonUI(){

                        @Override
                        public void paint(Graphics g, JComponent c) {
                            AbstractButton btn = (AbstractButton)c;
                            Graphics2D g2 = (Graphics2D)g.create();
                            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                            int w = c.getWidth();
                            int h = c.getHeight();
                            int r = 10;
                            Color base = ACCENT;
                            if (btn.getModel().isPressed()) {
                                base = new Color(25, 118, 210);
                            } else if (btn.getModel().isRollover()) {
                                base = new Color(66, 165, 245);
                            }
                            g2.setColor(base);
                            g2.fillRoundRect(0, 0, w, h, r, r);
                            g2.setColor(new Color(255, 255, 255, 40));
                            g2.drawRoundRect(0, 0, w - 1, h - 1, r, r);
                            g2.setColor(Color.WHITE);
                            FontMetrics fm = g2.getFontMetrics();
                            int x = (w - fm.stringWidth(btn.getText())) / 2;
                            int y = (h + fm.getAscent()) / 2 - 2;
                            g2.drawString(btn.getText(), x, y);
                            g2.dispose();
                        }
                    });
                }
                gbc.gridy = 1;
                gbc.insets = new Insets(8, 24, 20, 24);
                glass.add((Component)buttons, gbc);
                buttons.add(download);
                buttons.add(openMods);
                buttons.add(quit);
                download.addActionListener(e -> {
                    try {
                        Desktop.getDesktop().browse(new URI("https://optifine.net/downloads"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                openMods.addActionListener(e -> {
                    try {
                        Desktop.getDesktop().open(new File(System.getProperty("user.dir") + "/mods"));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                });
                ActionListener terminateAction = e -> this.terminateImmediately();
                quit.addActionListener(terminateAction);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        OptifineCheck.this.terminateImmediately();
                    }
                });
                dialog.setPreferredSize(new Dimension(560, 230));
                dialog.pack();
                dialog.setLocationRelativeTo(null);
                dialog.setVisible(true);
            });
        }
        catch (Exception e) {
            this.terminateImmediately();
        }
    }

    private void terminateImmediately() {
        try {
            Runtime.getRuntime().halt(1);
        }
        catch (Throwable t) {
            System.exit(1);
        }
    }

    private boolean isOptiFineInstalled() {
        File modsFolder = new File(System.getProperty("user.dir") + "/mods");
        File[] files = modsFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().startsWith("OptiFine") || !file.getName().endsWith(".jar")) continue;
                return true;
            }
        }
        return false;
    }
}

