/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.minewacheroleplaymod;

import de.sarocesch.minewacheroleplaymod.ElementsMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.IProxyMinewacheRolePlayMod;
import de.sarocesch.minewacheroleplaymod.network.NetworkHandler;
import de.sarocesch.minewacheroleplaymod.util.DependencyManager;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="saros_new_blocks_mod", version="5.6")
public class MinewacheRoleplayModMain {
    public static final String MODID = "saros_new_blocks_mod";
    public static final String VERSION = "5.6";
    public static final SimpleNetworkWrapper PACKET_HANDLER = NetworkRegistry.INSTANCE.newSimpleChannel("saros_new_blocks_m:a");
    @SidedProxy(clientSide="de.sarocesch.minewacheroleplaymod.ClientProxyMinewacheRolePlayMod", serverSide="de.sarocesch.minewacheroleplaymod.ServerProxyMinewacheRolePlayMod")
    public static IProxyMinewacheRolePlayMod proxy;
    @Mod.Instance(value="saros_new_blocks_mod")
    public static MinewacheRoleplayModMain instance;
    public ElementsMinewacheRolePlayMod elements = new ElementsMinewacheRolePlayMod();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        DependencyManager.logAvailabilitySummary();
        MinecraftForge.EVENT_BUS.register((Object)this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.elements, (int)5);
        GameRegistry.registerFuelHandler((IFuelHandler)this.elements);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new ElementsMinewacheRolePlayMod.GuiHandler());
        this.elements.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)this.elements);
        this.elements.getElements().forEach(element -> element.preInit(event));
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.elements.getElements().forEach(element -> element.init(event));
        proxy.init(event);
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        this.elements.getElements().forEach(element -> element.serverLoad(event));
        proxy.serverLoad(event);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blocks = (Block[])this.elements.getBlocks().stream().map(Supplier::get).filter(block -> block != null).toArray(Block[]::new);
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        ArrayList<Item> toRegister = new ArrayList<Item>();
        for (Supplier<Item> supplier : this.elements.getItems()) {
            try {
                Item item = supplier.get();
                if (item == null || item.getRegistryName() == null || event.getRegistry().containsKey(item.getRegistryName())) continue;
                toRegister.add(item);
            }
            catch (Exception e) {
                System.err.println("[MinewacheRoleplayModMain] Error creating item from supplier: " + e.getMessage());
            }
        }
        if (!toRegister.isEmpty()) {
            event.getRegistry().registerAll((IForgeRegistryEntry[])toRegister.toArray(new Item[0]));
        }
    }

    @SubscribeEvent
    public void registerBiomes(RegistryEvent.Register<Biome> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.elements.getBiomes().stream().map(Supplier::get).toArray(Biome[]::new));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.elements.getEntities().stream().map(Supplier::get).toArray(EntityEntry[]::new));
    }

    @SubscribeEvent
    public void registerPotions(RegistryEvent.Register<Potion> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])this.elements.getPotions().stream().map(Supplier::get).toArray(Potion[]::new));
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        this.elements.registerSounds(event);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        this.elements.getElements().forEach(element -> element.registerModels(event));
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

